# -*-makefile-*-
#
# Copyright (C) 2010 by Erwin Rol <erwin@erwinrol.com>
# Copyright (C) 2008 by Sascha Hauer
#
# See CREDITS for details about who has contributed to this project.
#
# For further information about the PTXdist project and license conditions
# see the README file.
#

#
# We provide this package
#
PACKAGES-$(PTXCONF_GST_PLUGINS_BAD11) += gst-plugins-bad11

#
# Paths and names
#
GST_PLUGINS_BAD11_VERSION	:= 0.11.2
GST_PLUGINS_BAD11_MD5		:= 0353596b7911a46f2e65316e6af4b4c4
GST_PLUGINS_BAD11		:= gst-plugins-bad-$(GST_PLUGINS_BAD11_VERSION)
GST_PLUGINS_BAD11_SUFFIX	:= tar.bz2
GST_PLUGINS_BAD11_URL		:= http://gstreamer.freedesktop.org/src/gst-plugins-bad/$(GST_PLUGINS_BAD11).$(GST_PLUGINS_BAD11_SUFFIX)
GST_PLUGINS_BAD11_SOURCE	:= $(SRCDIR)/$(GST_PLUGINS_BAD11).$(GST_PLUGINS_BAD11_SUFFIX)
GST_PLUGINS_BAD11_DIR		:= $(BUILDDIR)/$(GST_PLUGINS_BAD11)


# ----------------------------------------------------------------------------
# Prepare
# ----------------------------------------------------------------------------

GST_PLUGINS_BAD11_ENABLE-$(PTXCONF_GST_PLUGINS_BAD11_ADPCMDEC)		+= adpcmdec
GST_PLUGINS_BAD11_ENABLE-$(PTXCONF_GST_PLUGINS_BAD11_ADPCMENC)		+= adpcmenc
GST_PLUGINS_BAD11_ENABLE-$(PTXCONF_GST_PLUGINS_BAD11_AIFF)		+= aiff
GST_PLUGINS_BAD11_ENABLE-$(PTXCONF_GST_PLUGINS_BAD11_ASFMUX)		+= asfmux
GST_PLUGINS_BAD11_ENABLE-$(PTXCONF_GST_PLUGINS_BAD11_AUDIOVISUALIZERS)	+= audiovisualizers
GST_PLUGINS_BAD11_ENABLE-$(PTXCONF_GST_PLUGINS_BAD11_AUTOCONVERT)	+= autoconvert
GST_PLUGINS_BAD11_ENABLE-$(PTXCONF_GST_PLUGINS_BAD11_CAMERABIN)		+= camerabin
GST_PLUGINS_BAD11_ENABLE-$(PTXCONF_GST_PLUGINS_BAD11_CAMERABIN2)	+= camerabin2
GST_PLUGINS_BAD11_ENABLE-$(PTXCONF_GST_PLUGINS_BAD11_LEGACYRESAMPLE)	+= legacyresample
GST_PLUGINS_BAD11_ENABLE-$(PTXCONF_GST_PLUGINS_BAD11_BAYER)		+= bayer
GST_PLUGINS_BAD11_ENABLE-$(PTXCONF_GST_PLUGINS_BAD11_CDXAPARSE)		+= cdxaparse
GST_PLUGINS_BAD11_ENABLE-$(PTXCONF_GST_PLUGINS_BAD11_DATAURISRC)	+= dataurisrc
GST_PLUGINS_BAD11_ENABLE-$(PTXCONF_GST_PLUGINS_BAD11_DCCP)		+= dccp
GST_PLUGINS_BAD11_ENABLEC-$(PTXCONF_GST_PLUGINS_BAD11_DEBUGUTILS)	+= debugutils
GST_PLUGINS_BAD11_ENABLEP-$(PTXCONF_GST_PLUGINS_BAD11_DEBUGUTILS)	+= debugutilsbad
GST_PLUGINS_BAD11_ENABLE-$(PTXCONF_GST_PLUGINS_BAD11_DTMF)		+= dtmf
GST_PLUGINS_BAD11_ENABLE-$(PTXCONF_GST_PLUGINS_BAD11_DVDSPU)		+= dvdspu
GST_PLUGINS_BAD11_ENABLE-$(PTXCONF_GST_PLUGINS_BAD11_FACEOVERLAY)	+= faceoverlay
GST_PLUGINS_BAD11_ENABLE-$(PTXCONF_GST_PLUGINS_BAD11_FESTIVAL)		+= festival
GST_PLUGINS_BAD11_ENABLE-$(PTXCONF_GST_PLUGINS_BAD11_FREEZE)		+= freeze
GST_PLUGINS_BAD11_ENABLE-$(PTXCONF_GST_PLUGINS_BAD11_FREEVERB)		+= freeverb
GST_PLUGINS_BAD11_ENABLE-$(PTXCONF_GST_PLUGINS_BAD11_FREI0R)		+= frei0r
GST_PLUGINS_BAD11_ENABLE-$(PTXCONF_GST_PLUGINS_BAD11_HDVPARSE)		+= hdvparse
GST_PLUGINS_BAD11_ENABLE-$(PTXCONF_GST_PLUGINS_BAD11_ID3TAG)		+= id3tag
GST_PLUGINS_BAD11_ENABLE-$(PTXCONF_GST_PLUGINS_BAD11_INTER)		+= inter
GST_PLUGINS_BAD11_ENABLE-$(PTXCONF_GST_PLUGINS_BAD11_JPEGFORMAT)	+= jpegformat
GST_PLUGINS_BAD11_ENABLEC-$(PTXCONF_GST_PLUGINS_BAD11_LIBRFB)		+= librfb
GST_PLUGINS_BAD11_ENABLEP-$(PTXCONF_GST_PLUGINS_BAD11_LIBRFB)		+= rfbsrc
GST_PLUGINS_BAD11_ENABLE-$(PTXCONF_GST_PLUGINS_BAD11_LIVEADDER)		+= liveadder
GST_PLUGINS_BAD11_ENABLE-$(PTXCONF_GST_PLUGINS_BAD11_MPEGDEMUX)		+= mpegdemux
GST_PLUGINS_BAD11_ENABLE-$(PTXCONF_GST_PLUGINS_BAD11_MPEGTSDEMUX)	+= mpegtsdemux
GST_PLUGINS_BAD11_ENABLE-$(PTXCONF_GST_PLUGINS_BAD11_MPEGTSMUX)		+= mpegtsmux
GST_PLUGINS_BAD11_ENABLE-$(PTXCONF_GST_PLUGINS_BAD11_MPEGPSMUX)		+= mpegpsmux
GST_PLUGINS_BAD11_ENABLE-$(PTXCONF_GST_PLUGINS_BAD11_MVE)		+= mve
GST_PLUGINS_BAD11_ENABLE-$(PTXCONF_GST_PLUGINS_BAD11_MXF)		+= mxf
GST_PLUGINS_BAD11_ENABLE-$(PTXCONF_GST_PLUGINS_BAD11_NFS)		+= nsf
GST_PLUGINS_BAD11_ENABLE-$(PTXCONF_GST_PLUGINS_BAD11_NUVDEMUX)		+= nuvdemux
GST_PLUGINS_BAD11_ENABLE-$(PTXCONF_GST_PLUGINS_BAD11_PCAPPARSE)		+= pcapparse
GST_PLUGINS_BAD11_ENABLE-$(PTXCONF_GST_PLUGINS_BAD11_PNM)		+= pnm
GST_PLUGINS_BAD11_ENABLE-$(PTXCONF_GST_PLUGINS_BAD11_RAWPARSE)		+= rawparse
# real plugin cannot be built on arch != x86
ifdef PTXCONF_ARCH_X86
GST_PLUGINS_BAD11_ENABLE-$(PTXCONF_GST_PLUGINS_BAD11_REAL)		+= real
endif
GST_PLUGINS_BAD11_ENABLE-$(PTXCONF_GST_PLUGINS_BAD11_REMOVESILENCE)	+= removesilence
GST_PLUGINS_BAD11_ENABLE-$(PTXCONF_GST_PLUGINS_BAD11_RTMP)		+= rtmp
GST_PLUGINS_BAD11_ENABLE-$(PTXCONF_GST_PLUGINS_BAD11_RTPMUX)		+= rtpmux
GST_PLUGINS_BAD11_ENABLE-$(PTXCONF_GST_PLUGINS_BAD11_RTPVP8)		+= rtpvp8
GST_PLUGINS_BAD11_ENABLEC-$(PTXCONF_GST_PLUGINS_BAD11_SCALETEMPO)	+= scaletempo
GST_PLUGINS_BAD11_ENABLEP-$(PTXCONF_GST_PLUGINS_BAD11_SCALETEMPO)	+= scaletempoplugin
GST_PLUGINS_BAD11_ENABLEC-$(PTXCONF_GST_PLUGINS_BAD11_SDP)		+= sdp
GST_PLUGINS_BAD11_ENABLEP-$(PTXCONF_GST_PLUGINS_BAD11_SDP)		+= sdpelem
GST_PLUGINS_BAD11_ENABLE-$(PTXCONF_GST_PLUGINS_BAD11_SEGMENTCLIP)	+= segmentclip
GST_PLUGINS_BAD11_ENABLE-$(PTXCONF_GST_PLUGINS_BAD11_SIREN)		+= siren
GST_PLUGINS_BAD11_ENABLE-$(PTXCONF_GST_PLUGINS_BAD11_SMOOTH)		+= smooth
GST_PLUGINS_BAD11_ENABLE-$(PTXCONF_GST_PLUGINS_BAD11_SPEED)		+= speed
GST_PLUGINS_BAD11_ENABLE-$(PTXCONF_GST_PLUGINS_BAD11_SUBENC)		+= subenc
GST_PLUGINS_BAD11_ENABLE-$(PTXCONF_GST_PLUGINS_BAD11_STEREO)		+= stereo
GST_PLUGINS_BAD11_ENABLE-$(PTXCONF_GST_PLUGINS_BAD11_TTA)		+= tta
GST_PLUGINS_BAD11_ENABLE-$(PTXCONF_GST_PLUGINS_BAD11_VIDEOFILTERS)	+= videofilters
GST_PLUGINS_BAD11_ENABLE-$(PTXCONF_GST_PLUGINS_BAD11_VIDEOMEASURE)	+= videomeasure
GST_PLUGINS_BAD11_ENABLEC-$(PTXCONF_GST_PLUGINS_BAD11_VIDEOPARSERS)	+= videoparsers
GST_PLUGINS_BAD11_ENABLEP-$(PTXCONF_GST_PLUGINS_BAD11_VIDEOPARSERS)	+= videoparsersbad
GST_PLUGINS_BAD11_ENABLE-$(PTXCONF_GST_PLUGINS_BAD11_VIDEOSIGNAL)	+= videosignal
GST_PLUGINS_BAD11_ENABLE-$(PTXCONF_GST_PLUGINS_BAD11_VMNC)		+= vmnc
GST_PLUGINS_BAD11_ENABLE-$(PTXCONF_GST_PLUGINS_BAD11_AVC)		+= avc
GST_PLUGINS_BAD11_ENABLE-$(PTXCONF_GST_PLUGINS_BAD11_SHM)		+= shm
GST_PLUGINS_BAD11_ENABLEC-$(PTXCONF_GST_PLUGINS_BAD11_VCD)		+= vcd
GST_PLUGINS_BAD11_ENABLEP-$(PTXCONF_GST_PLUGINS_BAD11_VCD)		+= vcdsrc
GST_PLUGINS_BAD11_ENABLE-$(PTXCONF_GST_PLUGINS_BAD11_ASSRENDER)		+= assrender
GST_PLUGINS_BAD11_ENABLE-$(PTXCONF_GST_PLUGINS_BAD11_VOAMRWBENC)	+= voamrwbenc
GST_PLUGINS_BAD11_ENABLE-$(PTXCONF_GST_PLUGINS_BAD11_VOAACENC)		+= voaacenc
GST_PLUGINS_BAD11_ENABLE-$(PTXCONF_GST_PLUGINS_BAD11_APEXSINK)		+= apexsink
GST_PLUGINS_BAD11_ENABLE-$(PTXCONF_GST_PLUGINS_BAD11_BZ2)		+= bz2
GST_PLUGINS_BAD11_ENABLE-$(PTXCONF_GST_PLUGINS_BAD11_CDAUDIO)		+= cdaudio
GST_PLUGINS_BAD11_ENABLE-$(PTXCONF_GST_PLUGINS_BAD11_CELT)		+= celt
GST_PLUGINS_BAD11_ENABLE-$(PTXCONF_GST_PLUGINS_BAD11_COG)		+= cog
GST_PLUGINS_BAD11_ENABLE-$(PTXCONF_GST_PLUGINS_BAD11_DC1394)		+= dc1394
GST_PLUGINS_BAD11_ENABLEC-$(PTXCONF_GST_PLUGINS_BAD11_DIRECTFB)		+= directfb
GST_PLUGINS_BAD11_ENABLEP-$(PTXCONF_GST_PLUGINS_BAD11_DIRECTFB)		+= dfbvideosink
GST_PLUGINS_BAD11_ENABLE-$(PTXCONF_GST_PLUGINS_BAD11_DIRAC)		+= dirac
GST_PLUGINS_BAD11_ENABLE-$(PTXCONF_GST_PLUGINS_BAD11_DTS)		+= dts
GST_PLUGINS_BAD11_ENABLE-$(PTXCONF_GST_PLUGINS_BAD11_DIVX)		+= divx
GST_PLUGINS_BAD11_ENABLE-$(PTXCONF_GST_PLUGINS_BAD11_RESINDVD)		+= resindvd
GST_PLUGINS_BAD11_ENABLE-$(PTXCONF_GST_PLUGINS_BAD11_FAAC)		+= faac
GST_PLUGINS_BAD11_ENABLE-$(PTXCONF_GST_PLUGINS_BAD11_FAAD)		+= faad
GST_PLUGINS_BAD11_ENABLEC-$(PTXCONF_GST_PLUGINS_BAD11_FBDEV)		+= fbdev
GST_PLUGINS_BAD11_ENABLEP-$(PTXCONF_GST_PLUGINS_BAD11_FBDEV)		+= fbdevsink
GST_PLUGINS_BAD11_ENABLE-$(PTXCONF_GST_PLUGINS_BAD11_FLITE)		+= flite
GST_PLUGINS_BAD11_ENABLE-$(PTXCONF_GST_PLUGINS_BAD11_GSM)		+= gsm
GST_PLUGINS_BAD11_ENABLE-$(PTXCONF_GST_PLUGINS_BAD11_JP2K)		+= jp2k
GST_PLUGINS_BAD11_ENABLE-$(PTXCONF_GST_PLUGINS_BAD11_KATE)		+= kate
GST_PLUGINS_BAD11_ENABLE-$(PTXCONF_GST_PLUGINS_BAD11_LADSPA)		+= ladspa
GST_PLUGINS_BAD11_ENABLE-$(PTXCONF_GST_PLUGINS_BAD11_LV2)		+= lv2
GST_PLUGINS_BAD11_ENABLE-$(PTXCONF_GST_PLUGINS_BAD11_LIBMMS)		+= libmms
GST_PLUGINS_BAD11_ENABLE-$(PTXCONF_GST_PLUGINS_BAD11_MODPLUG)		+= modplug
GST_PLUGINS_BAD11_ENABLE-$(PTXCONF_GST_PLUGINS_BAD11_MIMIC)		+= mimic
GST_PLUGINS_BAD11_ENABLE-$(PTXCONF_GST_PLUGINS_BAD11_MPEG2ENC)		+= mpeg2enc
GST_PLUGINS_BAD11_ENABLE-$(PTXCONF_GST_PLUGINS_BAD11_MPLEX)		+= mplex
GST_PLUGINS_BAD11_ENABLE-$(PTXCONF_GST_PLUGINS_BAD11_MUSEPACK)		+= musepack
GST_PLUGINS_BAD11_ENABLE-$(PTXCONF_GST_PLUGINS_BAD11_MUSICBRAINZ)	+= musicbrainz
GST_PLUGINS_BAD11_ENABLE-$(PTXCONF_GST_PLUGINS_BAD11_MYTHTV)		+= mythtv
GST_PLUGINS_BAD11_ENABLE-$(PTXCONF_GST_PLUGINS_BAD11_NAS)		+= nas
GST_PLUGINS_BAD11_ENABLE-$(PTXCONF_GST_PLUGINS_BAD11_NEON)		+= neon
GST_PLUGINS_BAD11_ENABLE-$(PTXCONF_GST_PLUGINS_BAD11_OPENAL)		+= openal
GST_PLUGINS_BAD11_ENABLE-$(PTXCONF_GST_PLUGINS_BAD11_OPENCV)		+= opencv
GST_PLUGINS_BAD11_ENABLE-$(PTXCONF_GST_PLUGINS_BAD11_OPUS)		+= opus
GST_PLUGINS_BAD11_ENABLE-$(PTXCONF_GST_PLUGINS_BAD11_PVR)		+= pvr
GST_PLUGINS_BAD11_ENABLE-$(PTXCONF_GST_PLUGINS_BAD11_RSVG)		+= rsvg
GST_PLUGINS_BAD11_ENABLE-$(PTXCONF_GST_PLUGINS_BAD11_TIMIDITY)		+= timidity
GST_PLUGINS_BAD11_ENABLE-$(PTXCONF_GST_PLUGINS_BAD11_TELETEXTDEC)	+= teletextdec
GST_PLUGINS_BAD11_ENABLE-$(PTXCONF_GST_PLUGINS_BAD11_WILDMIDI)		+= wildmidi
GST_PLUGINS_BAD11_ENABLE-$(PTXCONF_GST_PLUGINS_BAD11_SDL)		+= sdl
GST_PLUGINS_BAD11_ENABLE-$(PTXCONF_GST_PLUGINS_BAD11_SNDFILE)		+= sndfile
GST_PLUGINS_BAD11_ENABLE-$(PTXCONF_GST_PLUGINS_BAD11_SOUNDTOUCH)	+= soundtouch
GST_PLUGINS_BAD11_ENABLE-$(PTXCONF_GST_PLUGINS_BAD11_SPC)		+= spc
GST_PLUGINS_BAD11_ENABLE-$(PTXCONF_GST_PLUGINS_BAD11_GME)		+= gme
GST_PLUGINS_BAD11_ENABLE-$(PTXCONF_GST_PLUGINS_BAD11_SWFDEC)		+= swfdec
GST_PLUGINS_BAD11_ENABLE-$(PTXCONF_GST_PLUGINS_BAD11_XVID)		+= xvid
GST_PLUGINS_BAD11_ENABLE-$(PTXCONF_GST_PLUGINS_BAD11_DVB)		+= dvb
GST_PLUGINS_BAD11_ENABLE-$(PTXCONF_GST_PLUGINS_BAD11_WININET)		+= wininet
GST_PLUGINS_BAD11_ENABLE-$(PTXCONF_GST_PLUGINS_BAD11_ACM)		+= acm
GST_PLUGINS_BAD11_ENABLE-$(PTXCONF_GST_PLUGINS_BAD11_VDPAU)		+= vdpau
GST_PLUGINS_BAD11_ENABLE-$(PTXCONF_GST_PLUGINS_BAD11_SCHRO)		+= schro
GST_PLUGINS_BAD11_ENABLE-$(PTXCONF_GST_PLUGINS_BAD11_ZBAR)		+= zbar
GST_PLUGINS_BAD11_ENABLE-$(PTXCONF_GST_PLUGINS_BAD11_VP8)		+= vp8
GST_PLUGINS_BAD11_ENABLE-$(PTXCONF_GST_PLUGINS_BAD11_COLOREFFECTS)	+= coloreffects
GST_PLUGINS_BAD11_ENABLE-$(PTXCONF_GST_PLUGINS_BAD11_DVBSUBOVERLAY)	+= dvbsuboverlay
GST_PLUGINS_BAD11_ENABLE-$(PTXCONF_GST_PLUGINS_BAD11_GAUDIEFFECTS)	+= gaudieffects
GST_PLUGINS_BAD11_ENABLE-$(PTXCONF_GST_PLUGINS_BAD11_GEOMETRICTRANSFORM)+= geometrictransform
GST_PLUGINS_BAD11_ENABLE-$(PTXCONF_GST_PLUGINS_BAD11_INTERLACE)		+= interlace
GST_PLUGINS_BAD11_ENABLE-$(PTXCONF_GST_PLUGINS_BAD11_IVFPARSE)		+= ivfparse
GST_PLUGINS_BAD11_ENABLE-$(PTXCONF_GST_PLUGINS_BAD11_JP2KDECIMATOR)	+= jp2kdecimator
# FIXME: The plugin is called y4mdec, so the magic doesn't work any more
GST_PLUGINS_BAD11_ENABLE-$(PTXCONF_GST_PLUGINS_BAD11_Y4M)		+= y4m

GST_PLUGINS_BAD11_ENABLEC-y	+= $(GST_PLUGINS_BAD11_ENABLE-y)
GST_PLUGINS_BAD11_ENABLEC-	+= $(GST_PLUGINS_BAD11_ENABLE-)
GST_PLUGINS_BAD11_ENABLEP-y	+= $(GST_PLUGINS_BAD11_ENABLE-y)

#
# autoconf
#
GST_PLUGINS_BAD11_CONF_TOOL	:= autoconf

GST_PLUGINS_BAD11_CONF_OPT := \
	$(CROSS_AUTOCONF_USR) \
	$(GSTREAMER_GENERIC_CONF_OPT) \
	--enable-external \
	--enable-experimental \
	--disable-directsound \
	--disable-direct3d \
	--disable-directdraw \
	--disable-apple_media \
	--disable-osx_video \
	--disable-quicktime \
	--disable-sdltest

ifneq ($(call remove_quotes,$(GST_PLUGINS_BAD11_ENABLEC-y)),)
GST_PLUGINS_BAD11_CONF_OPT +=  --enable-$(subst $(space),$(space)--enable-,$(strip $(GST_PLUGINS_BAD11_ENABLEC-y)))
endif

ifneq ($(call remove_quotes,$(GST_PLUGINS_BAD11_ENABLEC-)),)
GST_PLUGINS_BAD11_CONF_OPT +=  --disable-$(subst $(space),$(space)--disable-,$(strip $(GST_PLUGINS_BAD11_ENABLEC-)))
endif

#  --enable-gobject-cast-checks=[no/auto/yes] Enable GObject cast checks


# ----------------------------------------------------------------------------
# Target-Install
# ----------------------------------------------------------------------------

$(STATEDIR)/gst-plugins-bad11.targetinstall:
	@$(call targetinfo)

	@$(call install_init, gst-plugins-bad11)
	@$(call install_fixup, gst-plugins-bad11,PRIORITY,optional)
	@$(call install_fixup, gst-plugins-bad11,SECTION,base)
	@$(call install_fixup, gst-plugins-bad11,AUTHOR,"Sascha Hauer")
	@$(call install_fixup, gst-plugins-bad11,DESCRIPTION,missing)

	# install all activated libs
	@if [ -d  $(GST_PLUGINS_BAD11_PKGDIR)/usr/lib/ ]; then \
		cd $(GST_PLUGINS_BAD11_PKGDIR)/usr/lib/ && for libs in `find -name "*-0.11.so" | sed -e 's,\./\(.*\)\.so,\1,'`; do \
			$(call install_lib, gst-plugins-bad11, 0, 0, 0644, $$libs); \
		done \
	fi

	# install all activated plugins
	@for plugin in $(GST_PLUGINS_BAD11_ENABLEP-y); do \
		$(call install_copy, gst-plugins-bad11, 0, 0, 0644, -, \
			/usr/lib/gstreamer-0.11/libgst$${plugin}.so); \
	done

	@$(call install_finish, gst-plugins-bad11)

	@$(call touch)

# vim: syntax=make
