# -*-makefile-*-
#
# Copyright (C) 2010 by Erwin Rol <erwin@erwinrol.com>
# Copyright (C) 2008 by Sascha Hauer
#
# See CREDITS for details about who has contributed to this project.
#
# For further information about the PTXdist project and license conditions
# see the README file.
#

#
# We provide this package
#
PACKAGES-$(PTXCONF_GST_PLUGINS_BAD) += gst-plugins-bad

#
# Paths and names
#
GST_PLUGINS_BAD_VERSION	:= 0.10.23
GST_PLUGINS_BAD_MD5	:= fcb09798114461955260e4d940db5987
GST_PLUGINS_BAD		:= gst-plugins-bad-$(GST_PLUGINS_BAD_VERSION)
GST_PLUGINS_BAD_SUFFIX	:= tar.bz2
GST_PLUGINS_BAD_URL	:= http://gstreamer.freedesktop.org/src/gst-plugins-bad/$(GST_PLUGINS_BAD).$(GST_PLUGINS_BAD_SUFFIX)
GST_PLUGINS_BAD_SOURCE	:= $(SRCDIR)/$(GST_PLUGINS_BAD).$(GST_PLUGINS_BAD_SUFFIX)
GST_PLUGINS_BAD_DIR	:= $(BUILDDIR)/$(GST_PLUGINS_BAD)


# ----------------------------------------------------------------------------
# Prepare
# ----------------------------------------------------------------------------

GST_PLUGINS_BAD_ENABLE-$(PTXCONF_GST_PLUGINS_BAD_ADPCMDEC)	+= adpcmdec
GST_PLUGINS_BAD_ENABLE-$(PTXCONF_GST_PLUGINS_BAD_ADPCMENC)	+= adpcmenc
GST_PLUGINS_BAD_ENABLE-$(PTXCONF_GST_PLUGINS_BAD_AIFF)		+= aiff
GST_PLUGINS_BAD_ENABLE-$(PTXCONF_GST_PLUGINS_BAD_ASFMUX)	+= asfmux
GST_PLUGINS_BAD_ENABLE-$(PTXCONF_GST_PLUGINS_BAD_AUDIOVISUALIZERS) += audiovisualizers
GST_PLUGINS_BAD_ENABLE-$(PTXCONF_GST_PLUGINS_BAD_AUTOCONVERT)	+= autoconvert
GST_PLUGINS_BAD_ENABLE-$(PTXCONF_GST_PLUGINS_BAD_CAMERABIN)	+= camerabin
GST_PLUGINS_BAD_ENABLE-$(PTXCONF_GST_PLUGINS_BAD_CAMERABIN2)	+= camerabin2
GST_PLUGINS_BAD_ENABLE-$(PTXCONF_GST_PLUGINS_BAD_LEGACYRESAMPLE) += legacyresample
GST_PLUGINS_BAD_ENABLE-$(PTXCONF_GST_PLUGINS_BAD_BAYER)		+= bayer
GST_PLUGINS_BAD_ENABLE-$(PTXCONF_GST_PLUGINS_BAD_CDXAPARSE)	+= cdxaparse
GST_PLUGINS_BAD_ENABLE-$(PTXCONF_GST_PLUGINS_BAD_DATAURISRC)	+= dataurisrc
GST_PLUGINS_BAD_ENABLE-$(PTXCONF_GST_PLUGINS_BAD_DCCP)		+= dccp
GST_PLUGINS_BAD_ENABLEC-$(PTXCONF_GST_PLUGINS_BAD_DEBUGUTILS)	+= debugutils
GST_PLUGINS_BAD_ENABLEP-$(PTXCONF_GST_PLUGINS_BAD_DEBUGUTILS)	+= debugutilsbad
GST_PLUGINS_BAD_ENABLE-$(PTXCONF_GST_PLUGINS_BAD_DTMF)		+= dtmf
GST_PLUGINS_BAD_ENABLE-$(PTXCONF_GST_PLUGINS_BAD_DVDSPU)	+= dvdspu
GST_PLUGINS_BAD_ENABLE-$(PTXCONF_GST_PLUGINS_BAD_FACEOVERLAY)	+= faceoverlay
GST_PLUGINS_BAD_ENABLE-$(PTXCONF_GST_PLUGINS_BAD_FESTIVAL)	+= festival
GST_PLUGINS_BAD_ENABLE-$(PTXCONF_GST_PLUGINS_BAD_FREEZE)	+= freeze
GST_PLUGINS_BAD_ENABLE-$(PTXCONF_GST_PLUGINS_BAD_FREEVERB)	+= freeverb
GST_PLUGINS_BAD_ENABLE-$(PTXCONF_GST_PLUGINS_BAD_FREI0R)	+= frei0r
GST_PLUGINS_BAD_ENABLE-$(PTXCONF_GST_PLUGINS_BAD_H264PARSE)	+= h264parse
GST_PLUGINS_BAD_ENABLE-$(PTXCONF_GST_PLUGINS_BAD_HDVPARSE)	+= hdvparse
GST_PLUGINS_BAD_ENABLE-$(PTXCONF_GST_PLUGINS_BAD_ID3TAG)	+= id3tag
GST_PLUGINS_BAD_ENABLE-$(PTXCONF_GST_PLUGINS_BAD_INTER)		+= inter
GST_PLUGINS_BAD_ENABLE-$(PTXCONF_GST_PLUGINS_BAD_JPEGFORMAT)	+= jpegformat
GST_PLUGINS_BAD_ENABLEC-$(PTXCONF_GST_PLUGINS_BAD_LIBRFB)	+= librfb
GST_PLUGINS_BAD_ENABLEP-$(PTXCONF_GST_PLUGINS_BAD_LIBRFB)	+= rfbsrc
GST_PLUGINS_BAD_ENABLE-$(PTXCONF_GST_PLUGINS_BAD_LIVEADDER)	+= liveadder
GST_PLUGINS_BAD_ENABLE-$(PTXCONF_GST_PLUGINS_BAD_MPEGDEMUX)	+= mpegdemux
GST_PLUGINS_BAD_ENABLE-$(PTXCONF_GST_PLUGINS_BAD_MPEGTSMUX)	+= mpegtsmux
GST_PLUGINS_BAD_ENABLE-$(PTXCONF_GST_PLUGINS_BAD_MPEGPSMUX)	+= mpegpsmux
GST_PLUGINS_BAD_ENABLE-$(PTXCONF_GST_PLUGINS_BAD_MPEGVIDEOPARSE) += mpegvideoparse
GST_PLUGINS_BAD_ENABLE-$(PTXCONF_GST_PLUGINS_BAD_MVE)		+= mve
GST_PLUGINS_BAD_ENABLE-$(PTXCONF_GST_PLUGINS_BAD_MXF)		+= mxf
GST_PLUGINS_BAD_ENABLE-$(PTXCONF_GST_PLUGINS_BAD_NFS)		+= nsf
GST_PLUGINS_BAD_ENABLE-$(PTXCONF_GST_PLUGINS_BAD_NUVDEMUX)	+= nuvdemux
GST_PLUGINS_BAD_ENABLE-$(PTXCONF_GST_PLUGINS_BAD_PCAPPARSE)	+= pcapparse
GST_PLUGINS_BAD_ENABLE-$(PTXCONF_GST_PLUGINS_BAD_PNM)		+= pnm
GST_PLUGINS_BAD_ENABLE-$(PTXCONF_GST_PLUGINS_BAD_RAWPARSE)	+= rawparse
# real plugin cannot be built on arch != x86
ifdef PTXCONF_ARCH_X86
GST_PLUGINS_BAD_ENABLE-$(PTXCONF_GST_PLUGINS_BAD_REAL)		+= real
endif
GST_PLUGINS_BAD_ENABLE-$(PTXCONF_GST_PLUGINS_BAD_REMOVESILENCE)	+= removesilence
GST_PLUGINS_BAD_ENABLE-$(PTXCONF_GST_PLUGINS_BAD_RTPMUX)	+= rtpmux
GST_PLUGINS_BAD_ENABLEC-$(PTXCONF_GST_PLUGINS_BAD_SCALETEMPO)	+= scaletempo
GST_PLUGINS_BAD_ENABLEP-$(PTXCONF_GST_PLUGINS_BAD_SCALETEMPO)	+= scaletempoplugin
GST_PLUGINS_BAD_ENABLEC-$(PTXCONF_GST_PLUGINS_BAD_SDP)		+= sdp
GST_PLUGINS_BAD_ENABLEP-$(PTXCONF_GST_PLUGINS_BAD_SDP)		+= sdpelem
GST_PLUGINS_BAD_ENABLE-$(PTXCONF_GST_PLUGINS_BAD_SEGMENTCLIP)	+= segmentclip
GST_PLUGINS_BAD_ENABLE-$(PTXCONF_GST_PLUGINS_BAD_SIREN)		+= siren
GST_PLUGINS_BAD_ENABLE-$(PTXCONF_GST_PLUGINS_BAD_SMOOTH)	+= smooth
GST_PLUGINS_BAD_ENABLE-$(PTXCONF_GST_PLUGINS_BAD_SPEED)		+= speed
GST_PLUGINS_BAD_ENABLE-$(PTXCONF_GST_PLUGINS_BAD_SUBENC)	+= subenc
GST_PLUGINS_BAD_ENABLE-$(PTXCONF_GST_PLUGINS_BAD_STEREO)	+= stereo
GST_PLUGINS_BAD_ENABLE-$(PTXCONF_GST_PLUGINS_BAD_TTA)		+= tta
GST_PLUGINS_BAD_ENABLE-$(PTXCONF_GST_PLUGINS_BAD_VIDEOMEASURE)	+= videomeasure
GST_PLUGINS_BAD_ENABLE-$(PTXCONF_GST_PLUGINS_BAD_VIDEOSIGNAL)	+= videosignal
GST_PLUGINS_BAD_ENABLE-$(PTXCONF_GST_PLUGINS_BAD_VMNC)		+= vmnc
GST_PLUGINS_BAD_ENABLE-$(PTXCONF_GST_PLUGINS_BAD_AVC)		+= avc
GST_PLUGINS_BAD_ENABLE-$(PTXCONF_GST_PLUGINS_BAD_SHM)		+= shm
GST_PLUGINS_BAD_ENABLEC-$(PTXCONF_GST_PLUGINS_BAD_VCD)		+= vcd
GST_PLUGINS_BAD_ENABLEP-$(PTXCONF_GST_PLUGINS_BAD_VCD)		+= vcdsrc
GST_PLUGINS_BAD_ENABLE-$(PTXCONF_GST_PLUGINS_BAD_ASSRENDER)	+= assrender
GST_PLUGINS_BAD_ENABLE-$(PTXCONF_GST_PLUGINS_BAD_VOAMRWBENC)	+= voamrwbenc
GST_PLUGINS_BAD_ENABLE-$(PTXCONF_GST_PLUGINS_BAD_VOAACENC)	+= voaacenc
GST_PLUGINS_BAD_ENABLE-$(PTXCONF_GST_PLUGINS_BAD_APEXSINK)	+= apexsink
GST_PLUGINS_BAD_ENABLE-$(PTXCONF_GST_PLUGINS_BAD_BZ2)		+= bz2
GST_PLUGINS_BAD_ENABLE-$(PTXCONF_GST_PLUGINS_BAD_CDAUDIO)	+= cdaudio
GST_PLUGINS_BAD_ENABLE-$(PTXCONF_GST_PLUGINS_BAD_CELT)		+= celt
GST_PLUGINS_BAD_ENABLE-$(PTXCONF_GST_PLUGINS_BAD_COG)		+= cog
GST_PLUGINS_BAD_ENABLE-$(PTXCONF_GST_PLUGINS_BAD_DC1394)	+= dc1394
GST_PLUGINS_BAD_ENABLEC-$(PTXCONF_GST_PLUGINS_BAD_DIRECTFB)	+= directfb
GST_PLUGINS_BAD_ENABLEP-$(PTXCONF_GST_PLUGINS_BAD_DIRECTFB)	+= dfbvideosink
GST_PLUGINS_BAD_ENABLE-$(PTXCONF_GST_PLUGINS_BAD_DIRAC)		+= dirac
GST_PLUGINS_BAD_ENABLE-$(PTXCONF_GST_PLUGINS_BAD_DTS)		+= dts
GST_PLUGINS_BAD_ENABLE-$(PTXCONF_GST_PLUGINS_BAD_DIVX)		+= divx
GST_PLUGINS_BAD_ENABLE-$(PTXCONF_GST_PLUGINS_BAD_RESINDVD)	+= resindvd
GST_PLUGINS_BAD_ENABLE-$(PTXCONF_GST_PLUGINS_BAD_FAAC)		+= faac
GST_PLUGINS_BAD_ENABLE-$(PTXCONF_GST_PLUGINS_BAD_FAAD)		+= faad
GST_PLUGINS_BAD_ENABLEC-$(PTXCONF_GST_PLUGINS_BAD_FBDEV)	+= fbdev
GST_PLUGINS_BAD_ENABLEP-$(PTXCONF_GST_PLUGINS_BAD_FBDEV)	+= fbdevsink
GST_PLUGINS_BAD_ENABLE-$(PTXCONF_GST_PLUGINS_BAD_FLITE)		+= flite
GST_PLUGINS_BAD_ENABLE-$(PTXCONF_GST_PLUGINS_BAD_GSM)		+= gsm
GST_PLUGINS_BAD_ENABLE-$(PTXCONF_GST_PLUGINS_BAD_JP2K)		+= jp2k
GST_PLUGINS_BAD_ENABLE-$(PTXCONF_GST_PLUGINS_BAD_KATE)		+= kate
GST_PLUGINS_BAD_ENABLE-$(PTXCONF_GST_PLUGINS_BAD_LADSPA)	+= ladspa
GST_PLUGINS_BAD_ENABLE-$(PTXCONF_GST_PLUGINS_BAD_LV2)		+= lv2
GST_PLUGINS_BAD_ENABLE-$(PTXCONF_GST_PLUGINS_BAD_LIBMMS)	+= libmms
GST_PLUGINS_BAD_ENABLE-$(PTXCONF_GST_PLUGINS_BAD_MODPLUG)	+= modplug
GST_PLUGINS_BAD_ENABLE-$(PTXCONF_GST_PLUGINS_BAD_MIMIC)		+= mimic
GST_PLUGINS_BAD_ENABLE-$(PTXCONF_GST_PLUGINS_BAD_MPEG2ENC)	+= mpeg2enc
GST_PLUGINS_BAD_ENABLE-$(PTXCONF_GST_PLUGINS_BAD_MPLEX)		+= mplex
GST_PLUGINS_BAD_ENABLE-$(PTXCONF_GST_PLUGINS_BAD_MUSEPACK)	+= musepack
GST_PLUGINS_BAD_ENABLE-$(PTXCONF_GST_PLUGINS_BAD_MUSICBRAINZ)	+= musicbrainz
GST_PLUGINS_BAD_ENABLE-$(PTXCONF_GST_PLUGINS_BAD_MYTHTV)	+= mythtv
GST_PLUGINS_BAD_ENABLE-$(PTXCONF_GST_PLUGINS_BAD_NAS)		+= nas
GST_PLUGINS_BAD_ENABLE-$(PTXCONF_GST_PLUGINS_BAD_NEON)		+= neon
GST_PLUGINS_BAD_ENABLE-$(PTXCONF_GST_PLUGINS_BAD_OPENAL)	+= openal
GST_PLUGINS_BAD_ENABLE-$(PTXCONF_GST_PLUGINS_BAD_OPENCV)	+= opencv
GST_PLUGINS_BAD_ENABLE-$(PTXCONF_GST_PLUGINS_BAD_OPUS)		+= opus
GST_PLUGINS_BAD_ENABLE-$(PTXCONF_GST_PLUGINS_BAD_PVR)		+= pvr
GST_PLUGINS_BAD_ENABLE-$(PTXCONF_GST_PLUGINS_BAD_RSVG)		+= rsvg
GST_PLUGINS_BAD_ENABLE-$(PTXCONF_GST_PLUGINS_BAD_TIMIDITY)	+= timidity
GST_PLUGINS_BAD_ENABLE-$(PTXCONF_GST_PLUGINS_BAD_TELETEXTDEC)	+= teletextdec
GST_PLUGINS_BAD_ENABLE-$(PTXCONF_GST_PLUGINS_BAD_WILDMIDI)	+= wildmidi
GST_PLUGINS_BAD_ENABLE-$(PTXCONF_GST_PLUGINS_BAD_SDL)		+= sdl
GST_PLUGINS_BAD_ENABLE-$(PTXCONF_GST_PLUGINS_BAD_SNDFILE)	+= sndfile
GST_PLUGINS_BAD_ENABLE-$(PTXCONF_GST_PLUGINS_BAD_SOUNDTOUCH)	+= soundtouch
GST_PLUGINS_BAD_ENABLE-$(PTXCONF_GST_PLUGINS_BAD_SPC)		+= spc
GST_PLUGINS_BAD_ENABLE-$(PTXCONF_GST_PLUGINS_BAD_GME)		+= gme
GST_PLUGINS_BAD_ENABLE-$(PTXCONF_GST_PLUGINS_BAD_SWFDEC)	+= swfdec
GST_PLUGINS_BAD_ENABLE-$(PTXCONF_GST_PLUGINS_BAD_XVID)		+= xvid
GST_PLUGINS_BAD_ENABLE-$(PTXCONF_GST_PLUGINS_BAD_DVB)		+= dvb
GST_PLUGINS_BAD_ENABLE-$(PTXCONF_GST_PLUGINS_BAD_WININET)	+= wininet
GST_PLUGINS_BAD_ENABLE-$(PTXCONF_GST_PLUGINS_BAD_ACM)		+= acm
GST_PLUGINS_BAD_ENABLE-$(PTXCONF_GST_PLUGINS_BAD_VDPAU)		+= vdpau
GST_PLUGINS_BAD_ENABLE-$(PTXCONF_GST_PLUGINS_BAD_SCHRO)		+= schro
GST_PLUGINS_BAD_ENABLE-$(PTXCONF_GST_PLUGINS_BAD_ZBAR)		+= zbar
GST_PLUGINS_BAD_ENABLE-$(PTXCONF_GST_PLUGINS_BAD_VP8)		+= vp8
GST_PLUGINS_BAD_ENABLE-$(PTXCONF_GST_PLUGINS_BAD_COLOREFFECTS)	+= coloreffects
GST_PLUGINS_BAD_ENABLE-$(PTXCONF_GST_PLUGINS_BAD_COLORSPACE)	+= colorspace
GST_PLUGINS_BAD_ENABLE-$(PTXCONF_GST_PLUGINS_BAD_DVBSUBOVERLAY)	+= dvbsuboverlay
GST_PLUGINS_BAD_ENABLE-$(PTXCONF_GST_PLUGINS_BAD_GAUDIEFFECTS)	+= gaudieffects
GST_PLUGINS_BAD_ENABLE-$(PTXCONF_GST_PLUGINS_BAD_GEOMETRICTRANSFORMS) += geometrictransform
GST_PLUGINS_BAD_ENABLE-$(PTXCONF_GST_PLUGINS_BAD_INTERLACE)	+= interlace
GST_PLUGINS_BAD_ENABLE-$(PTXCONF_GST_PLUGINS_BAD_IVFPARSE)	+= ivfparse
GST_PLUGINS_BAD_ENABLE-$(PTXCONF_GST_PLUGINS_BAD_JP2DECIMATOR)	+= jp2kdecimator
GST_PLUGINS_BAD_ENABLE-$(PTXCONF_GST_PLUGINS_BAD_VIDEOMAXRATE)	+= videomaxrate
# FIXME: The plugin is called y4mdec, so the magic doesn't work any more
GST_PLUGINS_BAD_ENABLE-$(PTXCONF_GST_PLUGINS_BAD_Y4M)		+= y4m

GST_PLUGINS_BAD_ENABLEC-y	+= $(GST_PLUGINS_BAD_ENABLE-y)
GST_PLUGINS_BAD_ENABLEC-	+= $(GST_PLUGINS_BAD_ENABLE-)
GST_PLUGINS_BAD_ENABLEP-y	+= $(GST_PLUGINS_BAD_ENABLE-y)

#
# autoconf
#
GST_PLUGINS_BAD_CONF_TOOL	:= autoconf

GST_PLUGINS_BAD_CONF_OPT := \
	$(CROSS_AUTOCONF_USR) \
	$(GSTREAMER_GENERIC_CONF_OPT) \
	--enable-external \
	--enable-experimental \
	--disable-directsound \
	--disable-direct3d \
	--disable-directdraw \
	--disable-apple_media \
	--disable-osx_video \
	--disable-quicktime \
	--disable-sdltest

ifneq ($(call remove_quotes,$(GST_PLUGINS_BAD_ENABLEC-y)),)
GST_PLUGINS_BAD_CONF_OPT +=  --enable-$(subst $(space),$(space)--enable-,$(strip $(GST_PLUGINS_BAD_ENABLEC-y)))
endif

ifneq ($(call remove_quotes,$(GST_PLUGINS_BAD_ENABLEC-)),)
GST_PLUGINS_BAD_CONF_OPT +=  --disable-$(subst $(space),$(space)--disable-,$(strip $(GST_PLUGINS_BAD_ENABLEC-)))
endif

#  --enable-gobject-cast-checks=[no/auto/yes] Enable GObject cast checks


# ----------------------------------------------------------------------------
# Target-Install
# ----------------------------------------------------------------------------

$(STATEDIR)/gst-plugins-bad.targetinstall:
	@$(call targetinfo)

	@$(call install_init, gst-plugins-bad)
	@$(call install_fixup, gst-plugins-bad,PRIORITY,optional)
	@$(call install_fixup, gst-plugins-bad,SECTION,base)
	@$(call install_fixup, gst-plugins-bad,AUTHOR,"Sascha Hauer")
	@$(call install_fixup, gst-plugins-bad,DESCRIPTION,missing)

	# install all activated libs
	@if [ -d  $(GST_PLUGINS_BAD_PKGDIR)/usr/lib/ ]; then \
		cd $(GST_PLUGINS_BAD_PKGDIR)/usr/lib/ && for libs in `find -name "*-0.10.so" | sed -e 's,\./\(.*\)\.so,\1,'`; do \
			$(call install_lib, gst-plugins-bad, 0, 0, 0644, $$libs); \
		done \
	fi

	# install all activated plugins
	@for plugin in $(GST_PLUGINS_BAD_ENABLEP-y); do \
		$(call install_copy, gst-plugins-bad, 0, 0, 0644, -, \
			/usr/lib/gstreamer-0.10/libgst$${plugin}.so); \
	done

	@$(call install_finish, gst-plugins-bad)

	@$(call touch)

# vim: syntax=make
