# package_regex.inc - This file contains data that tracks
# upstream project associated with a given recipe. This list is needed
# for recipes that version information can not be automagically discovered.
# As we automate this checking, this file will slowly be reduced.
#"
# This data is used by the package reporting system (packages.yoctoproject.org)
#"
# The format is as a bitbake variable override for each recipe
#"
#       REGEX_URI_pn-<recipe name> = ""recipe_url"
#	 - This is the url used by the package checking system to
#	   get the latest version of the package
#       REGEX_pn-<recipe name> = ""package_regex"
#	 - This is the regex the package checking system uses to
#	   parse the page found at REGEX_URI_pn-<recipe name>
#
COMMON_REGEX = "((\d+[\.\-_]*)+)"
#This will need to be changed a little bit when versions are bigger than 9.
REGEX_URI_pn-acpid = "http://sourceforge.net/projects/acpid/files/acpid/"
REGEX_pn-acpid = "[hH][rR][eE][fF]=\"/projects/acpid/files/acpid/(acpid\-)?(?P<pver>(\d\.(\d+[\.\-_]*)+))/\""
REGEX_URI_pn-adt-installer = "http://code.google.com/p/opkg/downloads/list"
REGEX_URI_pn-arptables = "http://sourceforge.net/projects/ebtables/files/arptables/"
REGEX_pn-arptables = "[hH][rR][eE][fF]=\"/projects/ebtables/files/arptables/arptables-v(?P<pver>((\d+[\.\-_]*)+))/\""
REGEX_URI_pn-beecrypt = "http://sourceforge.net/projects/beecrypt/files/beecrypt/"
REGEX_pn-beecrypt = "[hH][rR][eE][fF]=\"/projects/beecrypt/files/beecrypt/(?P<pver>((\d+[\.\-_]*)+))/\""
REGEX_URI_pn-beecrypt-native = "http://sourceforge.net/projects/beecrypt/files/beecrypt/"
REGEX_pn-beecrypt-native = "[hH][rR][eE][fF]=\"/projects/beecrypt/files/beecrypt/(?P<pver>((\d+[\.\-_]*)+))/\""
REGEX_pn-bdwgc = "[hH][rR][eE][fF]=\"gc\-(?P<pver>((\d+[a-z]?[\.\-_]*)+))\.tar\.gz\""
REGEX_URI_pn-bind = "ftp://ftp.isc.org/isc/bind9/"
REGEX_pn-bind = "[hH][rR][eE][fF]=\"(?P<pver>((P?\d+[\.\-_]*)+))/\""
REGEX_URI_pn-bjam-native = "http://sourceforge.net/projects/boost/files/boost/"
REGEX_pn-bjam-native = "[hH][rR][eE][fF]=\"/projects/boost/files/boost/(?P<pver>((\d+[\.\-_]*)+))/\""
REGEX_pn-blktool = "[hH][rR][eE][fF]=\"blktool_(?P<pver>((\d+[\.\-_]*)+))\.(diff|orig\.tar)\.gz\""
REGEX_URI_pn-boost = "http://sourceforge.net/projects/boost/files/boost/"
REGEX_pn-boost = "[hH][rR][eE][fF]=\"/projects/boost/files/boost/(?P<pver>((\d+[\.\-_]*)+))/\""
REGEX_pn-btrfs-tools = "(?P<pver>(\d+(\.\d+)*(\-rc\d+)*))"
REGEX_pn-build-appliance-image = "(?P<pver>([0-9][\.|_]?)+)$"
REGEX_URI_pn-bzip2 = "http://www.bzip.org/downloads.html"
REGEX_pn-chkconfig-alternatives-native = "chkconfig\-(?P<pver>((\d+[\.\-_]*)+))"
REGEX_URI_pn-chrpath = "http://alioth.debian.org/frs/?group_id=31052"
REGEX_pn-chrpath = "[hH][rR][eE][fF]=\"/frs/download.php/file/\d+/chrpath-(?P<pver>((\d+[\.\-_]*)+))\.tar\.gz\""
REGEX_pn-cmake = "[hH][rR][eE][fF]=\"cmake\-(?P<pver>((\d+[\.\-_]*)+))\.tar\.gz\""
REGEX_pn-cmake-native = "[hH][rR][eE][fF]=\"cmake\-(?P<pver>((\d+[\.\-_]*)+))\.tar\.gz\""
REGEX_pn-nativeesdk-cmake = "[hH][rR][eE][fF]=\"cmake\-(?P<pver>((\d+[\.\-_]*)+))\.tar\.gz\""
REGEX_URI_pn-console-tools = "http://sourceforge.net/projects/lct/files/console-tools/"
REGEX_pn-console-tools = "[hH][rR][eE][fF]=\"/projects/lct/files/console-tools/(?P<pver>((\d+[\.\-_]*)+))/\""
REGEX_URI_pn-cracklib = "http://sourceforge.net/projects/cracklib/files/cracklib/"
REGEX_pn-cracklib = "[hH][rR][eE][fF]=\"/projects/cracklib/files/cracklib/(?P<pver>((\d+[\.\-_]*)+))/\""
REGEX_URI_pn-createrepo = "http://createrepo.baseurl.org/download/"
REGEX_pn-createrepo = "[hH][rR][eE][fF]=\"createrepo\-(?P<pver>((\d+[\.\-_]*)+))\.tar\.gz\""
REGEX_URI_pn-createrepo-native = "http://createrepo.baseurl.org/download/"
REGEX_pn-createrepo-native = "[hH][rR][eE][fF]=\"createrepo\-(?P<pver>((\d+[\.\-_]*)+))\.tar\.gz\""
REGEX_URI_pn-cups = "http://www.cups.org/software.php"
REGEX_pn-cups = "<tt>cups\-(?P<pver>((\d+[\.\-_]*)+))\-source\.tar\.gz<\/tt>"
REGEX_URI_pn-curlpp = "http://code.google.com/p/curlpp/downloads/list"
REGEX_URI_pn-cwautomacros = "http://sourceforge.net/projects/cwautomacros.berlios/files/"
REGEX_pn-cwautomacros = "[hH][rR][eE][fF]=\"http://sourceforge.net/projects/cwautomacros.berlios/files/cwautomacros\-(?P<pver>(\d+))\.tar\.bz2\/download""
REGEX_URI_pn-cwautomacros-native = "http://sourceforge.net/projects/cwautomacros.berlios/files/"
REGEX_pn-cwautomacros-native = "[hH][rR][eE][fF]=\"http://sourceforge.net/projects/cwautomacros.berlios/files/cwautomacros\-(?P<pver>(\d+))\.tar\.bz2\/download\""
REGEX_URI_pn-db = "http://www.oracle.com/technetwork/products/berkeleydb/downloads/index-082944.html"
REGEX_pn-db = "[hH][rR][eE][fF]=\"http://download.oracle.com/otn/berkeley-db/db-(?P<pver>((\d+[\.\-_]*)+))\.tar\.gz\""
REGEX_URI_pn-db-native = "http://www.oracle.com/technetwork/products/berkeleydb/downloads/index-082944.html"
REGEX_pn-db-native = "[hH][rR][eE][fF]=\"http://download.oracle.com/otn/berkeley-db/db-(?P<pver>((\d+[\.\-_]*)+))\.tar\.gz\""
REGEX_URI_pn-nativesdk-db = "http://www.oracle.com/technetwork/products/berkeleydb/downloads/index-082944.html"
REGEX_pn-nativesdk-db = "[hH][rR][eE][fF]=\"http://download.oracle.com/otn/berkeley-db/db-(?P<pver>((\d+[\.\-_]*)+))\.tar\.gz\""
REGEX_URI_pn-distcc = "http://code.google.com/p/distcc/downloads/list"
REGEX_pn-distcc = "[hH][rR][eE][fF]=\"//distcc.googlecode.com/files/distcc-(?P<pver>((\d+[\.\-_]*)+))\.tar\.bz2\""
REGEX_URI_pn-docbook-dsssl-stylesheets-native = "http://sourceforge.net/projects/docbook/files/docbook-dsssl/"
REGEX_pn-docbook-dsssl-stylesheets-native = "[hH][rR][eE][fF]=\"/projects/docbook/files/docbook-dsssl/(?P<pver>((\d+[\.\-_]*)+))/\""
REGEX_URI_pn-docbook-sgml-dtd-3.1-native = "http://docbook.org/sgml/3.1/"
PRSPV_pn-docbook-sgml-dtd-3.1-native = "${@d.getVar('PV',1).replace('.','')}"
REGEX_URI_pn-docbook-sgml-dtd-4.1-native = "http://docbook.org/sgml/4.1/"
PRSPV_pn-docbook-sgml-dtd-4.1-native = "${@d.getVar('PV',1).replace('.','')}"
REGEX_URI_pn-docbook-sgml-dtd-4.5-native = "http://docbook.org/sgml/4.5/"
REGEX_URI_pn-e2fsprogs = "http://sourceforge.net/projects/e2fsprogs/files/e2fsprogs/"
REGEX_pn-e2fsprogs = "[hH][rR][eE][fF]=\"/projects/e2fsprogs/files/e2fsprogs/v(?P<pver>((\d+[\.\-_]*)+))/\""
REGEX_pn-elfutils = "[hH][rR][eE][fF]=\"(elfutils\-)?(?P<pver>((\d+[\.\-_]*)+))(/|\.tar\.bz2)\""
REGEX_URI_pn-expat = "http://sourceforge.net/projects/expat/files/expat/"
REGEX_pn-expat-native = "[hH][rR][eE][fF]=\"/projects/expat/files/expat/(?P<pver>((\d+[\.\-_]*)+))/\""
REGEX_URI_pn-expat-native = "http://sourceforge.net/projects/expat/files/expat/"
REGEX_pn-expat = "[hH][rR][eE][fF]=\"/projects/expat/files/expat/(?P<pver>((\d+[\.\-_]*)+))/\""
REGEX_URI_pn-nativesdk-expat = "http://sourceforge.net/projects/expat/files/expat/"
REGEX_pn-nativesdk-expat = "[hH][rR][eE][fF]=\"/projects/expat/files/expat/(?P<pver>((\d+[\.\-_]*)+))/\""
REGEX_URI_pn-fetchmail = "http://sourceforge.net/projects/fetchmail.berlios/files/"
REGEX_URI_pn-flac = "http://sourceforge.net/projects/flac/files/flac-linux-i386/"
REGEX_pn-flac = "[hH][rR][eE][fF]=\"/projects/flac/files/flac-linux-i386/flac\-(?P<pver>((\d+[\.\-_]*)+))\-linux\-i386/\""
REGEX_URI_pn-flex = "http://sourceforge.net/projects/flex/files/"
REGEX_pn-flex = "[hH][rR][eE][fF]=\"http://sourceforge.net/projects/flex/files/flex-(?P<pver>((\d+[\.\-_]*)+)).tar.gz/download\""
REGEX_pn-foomatic-filters = "[hH][rR][eE][fF]=\"foomatic-filters-(?P<pver>((\d|\d\d)\.*)+)\.tar\.gz\""
REGEX_URI_pn-fotowall = "https://code.google.com/p/fotowall/downloads/list"
REGEX_pn-fotowall = "[hH][rR][eE][fF]=\"//fotowall.googlecode.com/files/[F|f]otowall\-(?P<pver>((\d+[\.\-_]*)+))\.tar\.bz2\""
REGEX_URI_pn-freetype = "http://sourceforge.net/projects/freetype/files/freetype2"
REGEX_pn-freetype = "[hH][rR][eE][fF]=\"/projects/freetype/files/freetype\d/(?P<pver>((\d+[\.\-_]*)+))/\""
REGEX_URI_pn-freetype-native = "http://sourceforge.net/projects/freetype/files/freetype2"
REGEX_pn-freetype-native = "[hH][rR][eE][fF]=\"/projects/freetype/files/freetype\d/(?P<pver>((\d+[\.\-_]*)+))/\""
REGEX_URI_pn-git = "http://code.google.com/p/git-core/downloads/list"
REGEX_pn-git = "[hH][rR][eE][fF]=\"//git-core.googlecode.com/files/git-(?P<pver>((\d+[\.\-_]*)+))\.tar\.gz\""
REGEX_URI_pn-glew = "http://sourceforge.net/projects/glew/files/glew"
REGEX_pn-glew  = " [hH][rR][eE][fF]=\"/projects/glew/files/glew/(?P<pver>((\d+[\.\-_]*)+))/\""
#REGEX_pn-gnutls = "ftp://ftp.gnutls.org/gcrypt/gnutls/"
REGEX_pn-gstreamer = "[hH][rR][eE][fF]=\"gstreamer\-(?P<pver>(0\.\d*[0|2|4|6|8]\.\d+))\.tar\.(gz|xz|bz2)\""
REGEX_pn-gstreamer1.0 = "[hH][rR][eE][fF]=\"gstreamer\-(?P<pver>(\d+\.\d*[0|2|4|6|8]\.\d+))\.tar\.(gz|xz|bz2)\""
REGEX_pn-gst-ffmpeg = "[hH][rR][eE][fF]=\"gst-ffmpeg\-(?P<pver>(\d+\.\d*[0|2|4|6|8]\.\d+))\.tar\.(gz|xz|bz2)\""
REGEX_pn-gst-fluendo-mpegdemux = "[hH][rR][eE][fF]=\"gst-fluendo-mpegdemux\-(?P<pver>(\d+\.\d*[0|2|4|6|8]\.\d+))\.tar\.(gz|xz|bz2)\""
REGEX_pn-gst-fluendo-mp3 = "[hH][rR][eE][fF]=\"gst-fluendo-mp3\-(?P<pver>(\d+\.\d*[0|2|4|6|8]\.\d+))\.tar\.(gz|xz|bz2)\""
REGEX_pn-gstreamer1.0-plugins-base = "[hH][rR][eE][fF]=\"gst\-plugins\-base\-(?P<pver>(\d+\.\d*[0|2|4|6|8]\.\d+))\.tar\.(gz|xz|bz2)\""
REGEX_pn-gst-plugins-base = "[hH][rR][eE][fF]=\"gst\-plugins\-base\-(?P<pver>(0\.\d*[0|2|4|6|8]\.\d+))\.tar\.(gz|xz|bz2)\""
REGEX_pn-gstreamer1.0-plugins-bad = "[hH][rR][eE][fF]=\"gst\-plugins\-bad\-(?P<pver>(\d+\.\d*[0|2|4|6|8]\.\d+))\.tar\.(gz|xz|bz2)\""
REGEX_pn-gst-plugins-bad = "[hH][rR][eE][fF]=\"gst\-plugins\-bad\-(?P<pver>(0\.\d*[0|2|4|6|8]\.\d+))\.tar\.(gz|xz|bz2)\""
REGEX_pn-gst-plugins-gl = "[hH][rR][eE][fF]=\"gst\-plugins\-gl\-(?P<pver>(\d+\.\d*[0|2|4|6|8]\.\d+))\.tar\.(gz|xz|bz2)\""
REGEX_pn-gstreamer1.0-plugins-good = "[hH][rR][eE][fF]=\"gst\-plugins\-good\-(?P<pver>(\d+\.\d*[0|2|4|6|8]\.\d+))\.tar\.(gz|xz|bz2)\""
REGEX_pn-gst-plugins-good = "[hH][rR][eE][fF]=\"gst\-plugins\-good\-(?P<pver>(0\.\d*[0|2|4|6|8]\.\d+))\.tar\.(gz|xz|bz2)\""
REGEX_pn-gstreamer1.0-libav = "[hH][rR][eE][fF]=\"gst\-libav\-(?P<pver>(\d+\.\d*[0|2|4|6|8]\.\d+))\.tar\.(gz|xz|bz2)\""
REGEX_pn-gstreamer1.0-omx = "[hH][rR][eE][fF]=\"gst\-omx\-(?P<pver>(\d+\.\d*[0|2|4|6|8]\.\d+))\.tar\.(gz|xz|bz2)\""
REGEX_pn-gst-openmax = "[hH][rR][eE][fF]=\"gst\-openmax\-(?P<pver>(\d+\.\d*[0|2|4|6|8]\.\d+))\.tar\.(gz|xz|bz2)\""
REGEX_pn-gstreamer1.0-plugins-ugly = "[hH][rR][eE][fF]=\"gst\-plugins\-ugly\-(?P<pver>(\d+\.\d*[0|2|4|6|8]\.\d+))\.tar\.(gz|xz|bz2)\""
REGEX_pn-gst-plugins-ugly = "[hH][rR][eE][fF]=\"gst\-plugins\-ugly\-(?P<pver>(0\.\d*[0|2|4|6|8]\.\d+))\.tar\.(gz|xz|bz2)\""
REGEX_pn-gtk+ = "[hH][rR][eE][fF]=\"gtk\+\-(?P<pver>((\d+[\.\-_]*)+))\.tar\.xz\""
REGEX_pn-gtk+3 = "[hH][rR][eE][fF]=\"gtk\+\-(?P<pver>((\d+[\.\-_]*)+))\.tar\.xz\""
REGEX_pn-gtk-update-icon-cache-native = "[hH][rR][eE][fF]=\"gtk\+\-(?P<pver>((\d+[\.\-_]*)+))\.tar\.xz\""
REGEX_pn-webkit-gtk = "[hH][rR][eE][fF]=\"webkitgtk\-(?P<pver>((\d+[\.\-_]*)+))\.tar\.xz\""
REGEX_URI_pn-hdparm = "http://sourceforge.net/projects/hdparm/files/hdparm/"
REGEX_pn-hdparm = "[hH][rR][eE][fF]=\"http://sourceforge.net/projects/hdparm/files/hdparm/hdparm-(?P<pver>((\d+[\.\-_]*)+)).tar.gz/download\""
REGEX_URI_pn-icu = "http://site.icu-project.org/download"
REGEX_pn-icu = "[hH][rR][eE][fF]=\"http://site.icu-project.org/download/((\d+[\.\-_]*)+)#(TOC\-)?ICU4J\-Download\" rel=\"nofollow\">(<b>)?(?P<pver>((\d+[\.\-_]*)+))(</b>)?"
REGEX_URI_pn-intltool = "https://launchpad.net/intltool/+download"
REGEX_pn-intltool = "[hH][rR][eE][fF]=\"https://launchpad.net/intltool/trunk/(?P<pver>((\d+[\.\-_]*)+))/\+download/intltool\-(\d+[\.\-_]*)+\.tar\.gz\""
REGEX_URI_pn-intltool-native = "https://launchpad.net/intltool/+download"
REGEX_pn-intltool-native = "[hH][rR][eE][fF]=\"https://launchpad.net/intltool/trunk/(?P<pver>((\d+[\.\-_]*)+))/\+download/intltool\-(\d+[\.\-_]*)+\.tar\.gz\""
REGEX_URI_pn-irda-utils = "http://sourceforge.net/projects/irda/files/irda-utils/"
REGEX_pn-irda-utils = "[hH][rR][eE][fF]=\"/projects/irda/files/irda-utils/(?P<pver>((\d+[\.\-_]*)+))/\""
REGEX_pn-iputils = "[Hh][Rr][Ee][Ff]=\"iputils\-(?P<pver>(s\d+))\.tar\.bz2\""
REGEX_URI_pn-jpeg = "http://www.ijg.org/files/"
REGEX_pn-jpeg = "[hH][rR][eE][fF]=\"jpegsrc.v(?P<pver>((\d+[a-z]*\d*)+))\.tar\.gz""
REGEX_URI_pn-js = "http://ftp.mozilla.org/pub/mozilla.org/js/"
REGEX_pn-js = "[hH][rR][eE][fF]=\"js-?(?P<pver>((\d+[\.\-_]*)+))\.tar\.gz\""
REGEX_URI_pn-json-c = "http://s3.amazonaws.com/json-c_releases/"
REGEX_pn-json-c = "releases/json-c-(?P<pver>(\d+[\.\-_]*)+).tar.gz"
REGEX_URI_pn-kconfig-frontends = "http://ymorin.is-a-geek.org/download/kconfig-frontends/"
REGEX_pn-kconfig-frontends = "[hH][rR][eE][fF]=\'kconfig\-frontends\-(?P<pver>((\d+[\.\-]*)+))\.tar\.xz\'"
GIT_REGEX_pn-kern-tools-native = "HEEEAD"
REGEX_URI_pn-lame = "http://sourceforge.net/projects/lame/files/lame/"
REGEX_pn-lame = "[hH][rR][eE][fF]=\"/projects/lame/files/lame/(?P<pver>((\d+[\.\-_]*)+))/\""
REGEX_URI_pn-less  = "http://www.greenwoodsoftware.com/less/download.html"
REGEX_pn-less = "[hH][rR][eE][fF]=\"less\-(?P<pver>(\d+))\.tar\.gz\""
REGEX_URI_pn-liba52 = "http://liba52.sourceforge.net/downloads.html"
REGEX_pn-liba52 = "[hH][rR][eE][fF]=\"/files/a52\w*\-(?P<pver>((\d+[a-z]?[\.\-_]*)+))\.tar\.gz\""
REGEX_URI_pn-libacpi = "http://www.ngolde.de/libacpi.html"
REGEX_URI_pn-libaio = "http://ftp.debian.org/debian/pool/main/liba/libaio/"
REGEX_pn-libaio = "[hH][rR][eE][fF]=\"libaio_(?P<pver>((\d+[\.\-_]*)+)).orig.tar.gz\""
REGEX_URI_pn-libarchive = "http://www.libarchive.org/"
REGEX_pn-libarchive = "[hH][rR][eE][fF]=\"downloads/libarchive\-(?P<pver>((\d+[\.\-_]*)+))\.tar\.gz\""
REGEX_URI_pn-libcgroup = "http://sourceforge.net/projects/libcg/files/libcgroup/"
#REGEX_pn-libcgroup = "[hH][rR][eE][fF]=\"/projects/libcg/files/libcgroup/v?(?P<pver>((\.?\d+[\.\-_]*)+(rc\d?)*)+)/\""
REGEX_pn-libcgroup = "[hH][rR][eE][fF]=\"/projects/libcg/files/libcgroup/v?(?P<pver>((\.?\d+[\.\-_]*))+)/\""
REGEX_URI_pn-libcheck = "http://sourceforge.net/projects/check/files/check/"
REGEX_pn-libcheck = "[hH][rR][eE][fF]=\"/projects/check/files/check/(?P<pver>((\d+[\.\-_]*)+))/\""
REGEX_URI_pn-libdnet = "http://code.google.com/p/libdnet/downloads/list"
#REGEX_URI_pn-libevent = "http://sourceforge.net/projects/levent/files/libevent/libevent-2.0/"
REGEX_URI_pn-libevent = "http://libevent.org/"
#REGEX_pn-libevent = "[hH][rR][eE][fF]=\"http://sourceforge.net/projects/levent/files/libevent/libevent-2.0/libevent-(?P<pver>((\d+[\.\-_]*)+))\-stable\.tar\.gz/download\""
REGEX_pn-libevent = "[hH][rR][eE][fF]=\"https://github.com/downloads/libevent/libevent/libevent-(?P<pver>((\d+[\.\-_]*)+))\-stable\.tar\.gz\""
REGEX_URI_pn-libexif = "http://sourceforge.net/projects/libexif/files/libexif/"
REGEX_pn-libexif = "[hH][rR][eE][fF]=\"/projects/libexif/files/libexif/(?P<pver>((\d+[\.\-_]*)+))/\""
REGEX_pn-libffi = "[hH][rR][eE][fF]=\"libffi\-(?P<pver>((\d+[\.\-_]*)+))\.tar\.gz\""
REGEX_pn-libffi-native = "[hH][rR][eE][fF]=\"ftp://sourceware.org:21/pub/libffi/libffi\-(?P<pver>((\d+[\.\-_]*)+))\.tar\.gz\""
REGEX_pn-nativesdk-libffi = "[hH][rR][eE][fF]=\"ftp://sourceware.org:21/pub/libffi/libffi\-(?P<pver>((\d+[\.\-_]*)+))\.tar\.gz\""
REGEX_URI_pn-libfm = "http://sourceforge.net/projects/pcmanfm/files/PCManFM%20%2B%20Libfm%20%28tarball%20release%29/PCManFM/"
REGEX_pn-libfm = "[hH][rR][eE][fF]=\"http://sourceforge.net/projects/pcmanfm/files/PCManFM%20%2B%20Libfm%20%28tarball%20release%29/PCManFM/pcmanfm-(?P<pver>((\d+[\.\-_]*)+)).tar.gz/download\""
REGEX_URI_pn-libical = "http://sourceforge.net/projects/libical/files/libical/"
REGEX_pn-libical = "[hH][rR][eE][fF]=\"/projects/libical/files/libical/libical-(?P<pver>((\d+[\.\-_]*)+))/\""
REGEX_URI_pn-libid3tag = "http://sourceforge.net/projects/mad/files/libid3tag/"
REGEX_pn-libid3tag = "[hH][rR][eE][fF]=\"/projects/mad/files/libid3tag/(?P<pver>((\d+[\.\-_]*)+([a-z]?)))/\""
REGEX_URI_pn-libmad = "http://sourceforge.net/projects/mad/files/libmad/"
REGEX_pn-libmad = "[hH][rR][eE][fF]=\"/projects/mad/files/libmad/(?P<pver>((\d+[\.\-_]*)+([a-z]?)))/\""
REGEX_URI_pn-libogg = "http://downloads.xiph.org/releases/ogg/"
REGEX_pn-libogg = "[hH][rR][eE][fF]=\"libogg\-(?P<pver>((\d+[\.\-_]*)+))\.tar\.gz\""
REGEX_URI_pn-libmpc = "http://www.multiprecision.org/index.php?prog=mpc&page=download"
REGEX_URI_pn-libomxil = "http://sourceforge.net/projects/omxil/files/omxil/"
REGEX_pn-libomxil = "[hH][rR][eE][fF]=\"/projects/omxil/files/omxil/Bellagio.20(?P<pver>((\d+[\.\-_]*)+))/\""
REGEX_URI_pn-libpcap = "http://www.tcpdump.org/release/"
REGEX_pn-libpcap = "[hH][rR][eE][fF]=\"libpcap-(?P<pver>((\d+[\.\-_]*)+)).tar.gz\""
REGEX_URI_pn-libpcre = "http://sourceforge.net/projects/pcre/files/pcre/"
REGEX_pn-libpcre = "[hH][rR][eE][fF]=\"/projects/pcre/files/pcre/(?P<pver>((\d+[\.\-_]*)+))/\""
REGEX_URI_pn-libpcre-native = "http://sourceforge.net/projects/pcre/files/pcre/"
REGEX_pn-libpcre-native = "[hH][rR][eE][fF]=\"/projects/pcre/files/pcre/(?P<pver>((\d+[\.\-_]*)+))/\""
REGEX_URI_pn-libpfm4 = "http://sourceforge.net/projects/perfmon2/files/libpfm4/"
REGEX_URI_pn-libpng = "http://sourceforge.net/projects/libpng/files/"
REGEX_pn-libpng = "[hH][rR][eE][fF]=\"/projects/libpng/files/latest/download\?source=files\" title=\"/libpng\d+(/(\d+\.?)+/)?libpng-(?P<pver>((\d+[\.\-_]*)+)).tar.gz"
REGEX_URI_pn-libpng-native = "ftp://ftp.simplesystems.org/pub/libpng/png/src/"
REGEX_pn-libpng-native = "[hH][rR][eE][fF]=\"ftp://ftp.simplesystems.org:21/pub/libpng/png/src/libpng-(?P<pver>((\d+[\.\-_]*)+)).tar.gz""
REGEX_URI_pn-libpng12 = "http://sourceforge.net/projects/libpng/files/libpng12/"
REGEX_pn-libpng12 = "[hH][rR][eE][fF]=\"/projects/libpng/files/libpng12/(?P<pver>((\d+[\.\-_]*)+))/\""
REGEX_URI_pn-libproxy = "http://code.google.com/p/libproxy/downloads/list"
REGEX_pn-libtheora = "[Hh][Rr][Ee][Ff]=\"libtheora\-(?P<pver>((\d+[\.\-_]*)+))\.tar\.gz\""
REGEX_URI_pn-libsamplerate0 = "http://www.mega-nerd.com/SRC/download.html"
REGEX_pn-libsamplerate0 = "[hH][rR][eE][fF]=\"libsamplerate\-(?P<pver>((\d+[\.\-_]*)+))\.tar\.gz\""
REGEX_URI_pn-libtirpc = "http://sourceforge.net/projects/libtirpc/files/libtirpc/"
REGEX_pn-libtirpc = "[hH][rR][eE][fF]=\"/projects/libtirpc/files/libtirpc/(?P<pver>((\d+[\.\-_]*)+))/\""
REGEX_URI_pn-libusb-compat = "http://sourceforge.net/projects/libusb/files/libusb-compat-0.1/"
REGEX_pn-libusb-compat = "[hH][rR][eE][fF]=\"/projects/libusb/files/libusb-compat-0.1/libusb-compat-(?P<pver>((\d+[\.\-_]*)+))/""
REGEX_URI_pn-libusb1 = "http://sourceforge.net/projects/libusb/files/libusb-1.0/"
REGEX_pn-libusb1 = "[hH][rR][eE][fF]=\"/projects/libusb/files/libusb-1.0/libusb-(?P<pver>((\d+[\.\-_]*)+))/""
REGEX_URI_pn-libvorbis = "http://downloads.xiph.org/releases/vorbis/"
REGEX_pn-libvorbis = "[hH][rR][eE][fF]=\"libvorbis-(?P<pver>((\d+[\.\-_]*)+))\.tar\.gz\""
REGEX_pn-libxslt = "[Hh][Rr][Ee][Ff]=\"libxslt\-(?P<pver>((\d+\.*)+))\.tar\.gz\""
REGEX_pn-linux-libc-headers-yocto = "v((?P<pver>((\d+[\.\-_]*)+)))"
REGEX_URI_pn-lrzsz = "http://ohse.de/uwe/software/lrzsz.html"
REGEX_URI_pn-lsb = "http://sourceforge.net/projects/lsb/files/lsb_release/"
REGEX_pn-lsb = "[hH][rR][eE][fF]=\"/projects/lsb/files/lsb_release/(?P<pver>((\d+[\.\-_]*)+))/\""
REGEX_URI_pn-lsbinitscripts = "http://pkgs.fedoraproject.org/repo/pkgs/initscripts/"
REGEX_pn-lsbinitscripts = "[hH][rR][eE][fF]=\"initscripts\-(?P<pver>((\d+[\.\-_]*)+))\.tar\.bz2/\""
REGEX_URI_pn-ltp = "http://sourceforge.net/projects/ltp/files/LTP%20Source"
REGEX_pn-ltp = "[hH][rR][eE][fF]=\"/projects/ltp/files/LTP%20Source/ltp\-(?P<pver>(\d+))/\""
REGEX_URI_pn-lzop = "http://www.lzop.org/download/"
REGEX_pn-lzop = "[hH][rR][eE][fF]=\"lzop\-(?P<pver>((\d+[\.\-_]*)+))\.tar\.gz\""
REGEX_URI_pn-lzop-native = "http://www.lzop.org/download/"
REGEX_pn-lzop-native = "[hH][rR][eE][fF]=\"lzop\-(?P<pver>((\d+[\.\-_]*)+))\.tar\.gz\""
REGEX_URI_pn-nativesdk-lzop = "http://www.lzop.org/download/"
REGEX_pn-nativesdk-lzop = "[hH][rR][eE][fF]=\"lzop\-(?P<pver>((\d+[\.\-_]*)+))\.tar\.gz\""
REGEX_URI_pn-mailx = "http://sourceforge.net/projects/heirloom/files/heirloom-mailx/"
REGEX_pn-mailx = "[hH][rR][eE][fF]=\"/projects/heirloom/files/heirloom-mailx/(?P<pver>((\d+[\.]*)+))/\""
REGEX_URI_pn-memcached = "http://code.google.com/p/memcached/downloads/list"
REGEX_URI_pn-menu-cache = "http://sourceforge.net/projects/lxde/files/menu-cache/"
REGEX_pn-menu-cache = "[hH][rR][eE][fF]=\"/projects/lxde/files/menu\-cache/menu-cache%20(?P<pver>((\d+[\.\-_]*)+))/\""
REGEX_pn-mesa = "[hH][rR][eE][fF]=\"MesaLib-(?P<pver>((\d+[\.\-_]*)+))(\-rc\d+)*.tar.gz\""
REGEX_URI_pn-mesa-glsl-native = "ftp://ftp.freedesktop.org/pub/mesa/"
REGEX_pn-mesa-glsl-native = "[hH][rR][eE][fF]=\"ftp://ftp.freedesktop.org:21/pub/mesa/(?P<pver>((\d+[\.\-_]*)+))/\""
REGEX_URI_pn-minicom = "https://alioth.debian.org/frs/?group_id=30018"
REGEX_pn-minicom = "[hH][rR][eE][fF]=\"/frs/download.php/file/\d+/minicom\-(?P<pver>((\d+[\.\-_]*)+))\.tar\.gz\""
REGEX_URI_pn-mingetty = "http://sourceforge.net/projects/mingetty/files/mingetty"
REGEX_pn-mingetty = "[hH][rR][eE][fF]=\"/projects/mingetty/files/mingetty/(?P<pver>((\d+[\.\-_]*)+))/\""
REGEX_URI_pn-mpeg2dec = "http://libmpeg2.sourceforge.net/downloads.html"
REGEX_pn-mpeg2dec = "[hH][rR][eE][fF]=\"/files/mpeg2dec-(?P<pver>((\d+[\.\-_]*)+)).tar.gz\""
REGEX_URI_pn-mpfr = "http://ftp.gnu.org/gnu/mpfr/"
REGEX_pn-mpfr = "[hH][rR][eE][fF]=\"mpfr-(?P<pver>((\d+[\.\-_]*)+)).tar.gz""
REGEX_URI_pn-mpfr-native = "http://ftp.gnu.org/gnu/mpfr/"
REGEX_pn-mpfr-native = "[hH][rR][eE][fF]=\"mpfr-(?P<pver>((\d+[\.\-_]*)+)).tar.gz\""
REGEX_URI_pn-msmtp = "http://sourceforge.net/projects/msmtp/files/msmtp/"
REGEX_pn-msmtp = "[hH][rR][eE][fF]=\"/projects/msmtp/files/msmtp/(?P<pver>((\d+[\.\-_]*)+))/\""
REGEX_URI_pn-nativesdk-mpfr = "http://ftp.gnu.org/gnu/mpfr/"
REGEX_pn-nativesdk-mpfr = "[hH][rR][eE][fF]=\"mpfr-(?P<pver>((\d+[\.\-_]*)+)).tar.gz\""
REGEX_URI_pn-net-snmp = "http://sourceforge.net/projects/net-snmp/files/net-snmp/"
REGEX_pn-net-snmp = "[hH][rR][eE][fF]=\"/projects/net-snmp/files/net-snmp/(?P<pver>((\d+[\.\-_]*)+))/\""
REGEX_URI_pn-netcat = "http://sourceforge.net/projects/netcat/files/netcat/"
REGEX_pn-netcat = "[hH][rR][eE][fF]=\"/projects/netcat/files/netcat/(?P<pver>((\d+[\.\-_]*)+))/\""
REGEX_URI_pn-nfs-utils = "http://sourceforge.net/projects/nfs/files/nfs-utils/"
REGEX_pn-nfs-utils = "[hH][rR][eE][fF]=\"/projects/nfs/files/nfs-utils/(?P<pver>((\d+[\.\-_]*)+))/\""
REGEX_URI_pn-ocf-linux = "http://sourceforge.net/projects/ocf-linux/files/ocf-linux/"
REGEX_pn-ocf-linux = "[hH][rR][eE][fF]=\"/projects/ocf-linux/files/ocf-linux/(?P<pver>((\d+[\.\-_]*)+))/\""
REGEX_URI_pn-openjade-native = "http://sourceforge.net/projects/openjade/files/openjade/"
REGEX_pn-openjade-native = "[hH][rR][eE][fF]=\"/projects/openjade/files/openjade/(?P<pver>((\d+[\.\-_]*)+))/\""
REGEX_URI_pn-opensp = "http://sourceforge.net/projects/openjade/files/opensp/"
REGEX_pn-opensp = "[hH][rR][eE][fF]=\"/projects/openjade/files/opensp/(?P<pver>((\d+[\.\-_]*)+))/\""
REGEX_URI_pn-opensp-native = "http://sourceforge.net/projects/openjade/files/opensp/"
REGEX_pn-opensp-native = "[hH][rR][eE][fF]=\"/projects/openjade/files/opensp/(?P<pver>((\d+[\.\-_]*)+))/\""
REGEX_URI_pn-opkg = "http://code.google.com/p/opkg/downloads/list"
REGEX_URI_pn-oprofile = "http://sourceforge.net/projects/oprofile/files/oprofile/"
REGEX_pn-oprofile = "[hH][rR][eE][fF]=\"/projects/oprofile/files/oprofile/oprofile-(?P<pver>((\d+[\.\-_]*)+))/\""
REGEX_URI_pn-ossp-uuid = "http://code.google.com/p/gnome-build-stage-1/downloads/list"
REGEX_URI_pn-pcmanfm = "http://sourceforge.net/projects/pcmanfm/files/PCManFM%20%2B%20Libfm%20%28tarball%20release%29/PCManFM/"
REGEX_pn-pcmanfm = "[hH][rR][eE][fF]=\"http://sourceforge.net/projects/pcmanfm/files/PCManFM.20.2B.20Libfm.20.28tarball.20release.29/PCManFM/pcmanfm-(?P<pver>((\d+[\.\-_]*)+)).tar.gz/download\""
REGEX_URI_pn-procps = "http://procps.sourceforge.net/download.html"
REGEX_pn-procps = "[hH][rR][eE][fF]=\"procps\-(?P<pver>((\d+[\.\-_]*)+))\.tar\.gz\""
REGEX_URI_pn-powertop = "https://01.org/powertop/downloads"
REGEX_URI_pn-pptp-linux = "http://sourceforge.net/projects/pptpclient/files/pptp/"
REGEX_pn-pptp-linux = "[hH][rR][eE][fF]=\"/projects/pptpclient/files/pptp/pptp-(?P<pver>((\d+[\.\-_]*)+))/\""
GIT_REGEX_pn-prelink = "cross_prelink"
REGEX_pn-prelink = "(?P<pver>cross_prelink)"
REGEX_URI_pn-psmisc = "http://sourceforge.net/projects/psmisc/files/psmisc/"
REGEX_pn-psmisc = "[hH][rR][eE][fF]=\"http://sourceforge.net/projects/psmisc/files/psmisc/psmisc\-(?P<pver>((\d+[\.\-_]*)+))\.tar\.gz/download\""
REGEX_URI_pn-ptpd = "http://sourceforge.net/projects/ptpd/files/ptpd/"
REGEX_pn-ptpd = "[hH][rR][eE][fF]=\"/projects/ptpd/files/ptpd/(?P<pver>((\d+[\.\-_]*)+))/stats/timeline\""
REGEX_URI_pn-python-argparse = "https://code.google.com/p/argparse/downloads/list"
REGEX_URI_pn-python-docutils = "http://sourceforge.net/projects/docutils/files/docutils/"
REGEX_pn-python-docutils = "[hH][rR][eE][fF]=\"/projects/docutils/files/docutils/(?P<pver>((\d+[\.\-_]*)+)).*/\""
REGEX_URI_pn-python-numpy = "http://sourceforge.net/projects/numpy/files/NumPy/"
REGEX_pn-python-numpy = "[hH][rR][eE][fF]=\"/projects/numpy/files/latest/download\?source=files\" title=\"/NumPy/(\d+\.?)+/numpy-(?P<pver>((\d+[\.\-_]*)+)).tar.gz"
REGEX_URI_pn-python-pycurl = "http://pycurl.sourceforge.net/download/"
REGEX_pn-python-pycurl = "[hH][rR][eE][fF]=\"pycurl-(?P<pver>((\d+[\.\-_]*)+)).tar.gz\""
REGEX_URI_pn-python-scons = "http://sourceforge.net/projects/scons/files/scons/"
REGEX_pn-python-scons = "[hH][rR][eE][fF]=\"/projects/scons/files/scons/(?P<pver>((\d+[\.\-_]*)+)).*/\""
REGEX_URI_pn-python-scons-native = "http://sourceforge.net/projects/scons/files/scons/"
REGEX_pn-python-scons-native = "[hH][rR][eE][fF]=\"/projects/scons/files/scons/(?P<pver>((\d+[\.\-_]*)+)).*/\""
REGEX_pn-python-setuptools = "[hH][rR][eE][fF]=\"setuptools\-(?P<pver>((\d+([a-z]\d+)?[\.\-_]*)+))\.(tar\.gz|\.zip)\""
REGEX_URI_pn-quota = "http://sourceforge.net/projects/linuxquota/files/quota-tools/"
REGEX_pn-quota = "[hH][rR][eE][fF]=\"/projects/linuxquota/files/quota-tools/(?P<pver>((\d+[\.\-_]*)+([-\w\d]+)))/\""
REGEX_pn-remake = "(?P<pver>(\d+\.(\d+\.)*\d*(\+dbg\-\d+(\.\d+)*)*))"
REGEX_URI_pn-rpcbind = "http://sourceforge.net/projects/rpcbind/files/rpcbind/"
REGEX_pn-rpcbind = "[hH][rR][eE][fF]=\"/projects/rpcbind/files/rpcbind/(?P<pver>((\d+[\.\-_]*)+))/\""
REGEX_pn-rpm = "[hH][rR][eE][fF]=\"rpm\-(?P<pver>((\d+[\.\-_]*)+)\-(\d+[\.]*)+)\.src\.rpm\""
REGEX_pn-rpm-native = "[hH][rR][eE][fF]=\"rpm\-(?P<pver>((\d+[\.\-_]*)+)\-(\d+[\.]*)+)\.src\.rpm\""
REGEX_URI_pn-setserial = "http://sourceforge.net/projects/setserial/files/setserial/"
REGEX_pn-setserial = "[hH][rR][eE][fF]=\"/projects/setserial/files/setserial/(?P<pver>((\d+[\.\-_]*)+))/\""
REGEX_pn-shared-mime-info = "[hH][rR][eE][fF]=\"shared\-mime\-info\-(?P<pver>((\d+[\.\-_]*)+))\.tar\.(bz2|gz|xz)\""
REGEX_pn-shared-mime-info-native = "[hH][rR][eE][fF]=\"shared\-mime\-info\-(?P<pver>((\d+[\.\-_]*)+))\.tar\.(bz2|gz|xz)\""
REGEX_URI_pn-socat = "http://www.dest-unreach.org/socat/download/"
REGEX_pn-socat = "[hH][rR][eE][fF]=\"socat\-(?P<pver>((\d+[\.\-]*)+))\.tar\.bz2\""
REGEX_URI_pn-speex = "http://downloads.us.xiph.org/releases/speex/"
REGEX_pn-speex = "[hH][rR][eE][fF]=\"speex\-(?P<pver>((\d+\.*)+))\.tar\.gz\""
REGEX_URI_pn-sqlite3 = "http://www.sqlite.org/download.html"
REGEX_pn-sqlite3 = "sqlite-autoconf-(?P<pver>(\d+)).tar.gz"
REGEX_URI_pn-sqlite3-native = "http://www.sqlite.org/download.html"
REGEX_pn-sqlite3-native = "[hH][rR][eE][fF]=\"/sqlite-autoconf-(?P<pver>(\d+)).tar.gz\""
REGEX_URI_pn-nativesdk-sqlite3 = "http://www.sqlite.org/download.html"
REGEX_pn-nativesdk-sqlite3 = "[hH][rR][eE][fF]=\"/sqlite-autoconf-(?P<pver>(\d+)).tar.gz\""
REGEX_URI_pn-squashfs-tools = "http://sourceforge.net/projects/squashfs/files/squashfs/"
REGEX_pn-squashfs-tools = "[hH][rR][eE][fF]=\"/projects/squashfs/files/squashfs/squashfs(?P<pver>((\d+[\.\-_]*)+)).*/\""
REGEX_URI_pn-strace = "http://sourceforge.net/projects/strace/files/strace/"
REGEX_pn-strace = "[hH][rR][eE][fF]=\"/projects/strace/files/strace/(?P<pver>((\d+[\.\-_]*)+))/\""
REGEX_URI_pn-strace-native = "http://sourceforge.net/projects/strace/files/strace/"
REGEX_pn-strace-native = "[hH][rR][eE][fF]=\"/projects/strace/files/strace/(?P<pver>((\d+[\.\-_]*)+))/\""
REGEX_URI_pn-stunnel = "http://www.stunnel.org/downloads.html"
REGEX_pn-stunnel = "[hH][rR][eE][fF]=\"downloads/stunnel-(?P<pver>((\d+[\.\-_]*)+))\.tar\.gz\""
REGEX_URI_pn-sysfsutils = "http://sourceforge.net/projects/linux-diag/files/sysfsutils/"
REGEX_pn-sysfsutils = "[hH][rR][eE][fF]=\"/projects/linux-diag/files/sysfsutils/(?P<pver>((\d+[\.\-_]*)+))/\""
REGEX_URI_pn-sysstat = "http://sebastien.godard.pagesperso-orange.fr/download.html"
REGEX_pn-sysstat = "[hH][rR][eE][fF]=\"http://pagesperso-orange.fr/sebastien.godard/sysstat\-(?P<pver>((\d+[\.\-_]*)+))\.tar\.gz\""
REGEX_URI_pn-taglib = "http://github.com/taglib/taglib/releases/"
REGEX_URI_pn-tcl = "http://sourceforge.net/projects/tcl/files/Tcl/"
REGEX_pn-tcl = "[hH][rR][eE][fF]=\"/projects/tcl/files/Tcl/(?P<pver>((\d+(b\d+)?[\.\-_]*)+))/\""
REGEX_URI_pn-tcl-native = "http://sourceforge.net/projects/tcl/files/Tcl/"
REGEX_pn-tcl-native = "[hH][rR][eE][fF]=\"/projects/tcl/files/Tcl/(?P<pver>((\d+(b\d+)?[\.\-_]*)+))/\""
REGEX_URI_pn-tcpreplay = "http://sourceforge.net/projects/tcpreplay/files/tcpreplay/"
REGEX_pn-tcpreplay = "[hH][rR][eE][fF]=\"/projects/tcpreplay/files/tcpreplay/(?P<pver>((\d+[\.\-_]*)+))/\""
REGEX_URI_pn-tiff-native = "ftp://ftp.remotesensing.org/pub/libtiff/"
REGEX_pn-tiff-native = "[hH][rR][eE][fF]=\"ftp://ftp.remotesensing.org:21/pub/libtiff/tiff-(?P<pver>((\d+[\.\-_]*)+))\.tar\.gz\""
REGEX_URI_pn-tslib = "http://sourceforge.net/projects/tslib.berlios/files/"
REGEX_URI_pn-traceroute = "http://sourceforge.net/projects/traceroute/files/traceroute/"
REGEX_pn-traceroute = "[hH][rR][eE][fF]=\"/projects/traceroute/files/traceroute/traceroute-(?P<pver>((\d+[\.\-_]*)+))/\""
REGEX_pn-tslib = "[hH][rR][eE][fF]=\"http://sourceforge.net/projects/tslib.berlios/files/tslib\-(?P<pver>((\d+[\.\-_]*)+))\.tar\.bz2/download\""
REGEX_URI_pn-tunctl = "http://sourceforge.net/projects/tunctl/files/tunctl/"
REGEX_pn-tunctl = "[hH][rR][eE][fF]=\"/projects/tunctl/files/tunctl/(?P<pver>((\d+[\.\-_]*)+))/\""
REGEX_pn-tzdata = "[hH][rR][eE][fF]=\"tzdata(?P<pver>((\d+[a-z])+))\.tar\.gz\""
REGEX_URI_pn-unzip = "http://sourceforge.net/projects/infozip/files/UnZip%206.x%20%28latest%29/UnZip%206.0/"
REGEX_pn-unzip = "[hH][rR][eE][fF]=\"http://sourceforge.net/projects/infozip/files/UnZip%206.x%20%28latest%29/UnZip%206.0/unzip(?P<pver>(\d+))\.tar\.gz/download\""
PRSPV_pn-unzip = "${@d.getVar('PV',1).replace('.','')}"
REGEX_URI_pn-unzip-native = "http://sourceforge.net/projects/infozip/files/UnZip%206.x%20%28latest%29/UnZip%206.0/"
REGEX_pn-unzip-native = "[hH][rR][eE][fF]=\"http://sourceforge.net/projects/infozip/files/UnZip%206.x%20%28latest%29/UnZip%206.0/unzip(?P<pver>(\d+))\.tar\.gz/download\""
PRSPV_pn-unzip-native = "${@d.getVar('PV',1).replace('.','')}"
#REGEX_URI_pn-v86d = "http://dev.gentoo.org/~spock/projects/uvesafb/archive/"
REGEX_pn-v86d = "[hH][rR][eE][fF]=\"v86d\-(?P<pver>((\d+[\.]*)+))\.tar\.bz2\""
REGEX_URI_pn-vblade = "http://sourceforge.net/projects/aoetools/files/vblade/"
REGEX_pn-vblade = "[hH][rR][eE][fF]=\"/projects/aoetools/files/vblade/vblade-(?P<pver>((\d+[\.\-_]*)+))\.tgz/stats/timeline\""
REGEX_URI_pn-vsftpd = "https://security.appspot.com/vsftpd.html"
REGEX_pn-vsftpd = "[hH][rR][eE][fF]=\"https://security.appspot.com/downloads/vsftpd-(?P<pver>((\d+[\.\-_]*)+))\.tar\.gz\""
REGEX_URI_pn-watchdog = "http://sourceforge.net/projects/watchdog/files/watchdog/"
REGEX_pn-watchdog = "[hH][rR][eE][fF]=\"/projects/watchdog/files/watchdog/(?P<pver>((\d+[\.\-_]*)+))/\""
REGEX_URI_pn-wireless-tools = "http://www.hpl.hp.com/personal/Jean_Tourrilhes/Linux/Tools.html"
REGEX_pn-wireless-tools = "[hH][rR][eE][fF]=\"wireless_tools\.(?P<pver>(\d+))\.tar\.gz\""
REGEX_URI_pn-x11vnc = "http://sourceforge.net/projects/libvncserver/files/x11vnc/"
REGEX_pn-x11vnc = "[hH][rR][eE][fF]=\"/projects/libvncserver/files/x11vnc/(?P<pver>((\d+[\.\-_]*)+))/\""
REGEX_pn-xdg-utils = "[hH][rR][eE][fF]=\"xdg\-utils\-(?P<pver>((\d+[\.\-_]*)+))\.(tar\.gz|tgz)\""
REGEX_pn-xf86-video-omap = "(?P<pver>(\d+\.(\d\.?)*))"
REGEX_URI_pn-zip = "http://sourceforge.net/projects/infozip/files/Zip%203.x%20%28latest%29/3.0/"
REGEX_pn-zip = "[hH][rR][eE][fF]=\"http://sourceforge.net/projects/infozip/files/Zip%203.x%20%28latest%29/3.0/zip(?P<pver>(\d+))\.tar\.gz/download\""
PRSPV_pn-zip = "${@d.getVar('PV',1).replace('.','')}"
REGEX_URI_pn-zip-native = "http://sourceforge.net/projects/infozip/files/Zip%203.x%20%28latest%29/3.0/"
REGEX_pn-zip-native = "[hH][rR][eE][fF]=\"http://sourceforge.net/projects/infozip/files/Zip%203.x%20%28latest%29/3.0/zip(?P<pver>(\d+))\.tar\.gz/download\""
PRSPV_pn-zip-native = "${@d.getVar('PV',1).replace('.','')}"
REGEX_URI_pn-zisofs-tools-native ="http://pkgs.fedoraproject.org/repo/pkgs/zisofs-tools/"

# Regex used to parse tags and extract version
GITTAGREGEX_pn-build-appliance-image = "(?P<pver>(([0-9][\.|_]?)+[0-9]))"
GITTAGREGEX_pn-chkconfig-alternatives-native = "chkconfig\-(?P<pver>((\d+[\.\-_]*)+))"
GITTAGREGEX_pn-remake = "(?P<pver>(\d+\.(\d+\.)*\d*(\+dbg\d+(\.\d+)*)*))"
GITTAGREGEX_pn-xf86-video-omap = "(?P<pver>(\d+\.(\d\.?)*))"
