#!/bin/sh

GST_PATH="/usr/local/phytec-camera-examples/phytec-gstreamer-examples"
. $GST_PATH/func.sh

init_dev
[ $? -ne 0 ] && exit 1

guess_param

# Additional Settings
COL_FMT="0x20303159" # this value is the Y10 format
X_RES=${SENSOR_RES%%x*}
Y_RES=${SENSOR_RES##*x}
REG_SET_FILE=$GST_PATH/${REG_SET_FILE##*/}

echo ""
echo " configure camera with v4l2_control"
echo " =================================="

$V4L2_CTRL_CAM0
#$GST_PATH/tools/cam_regs.py -s subdev0 -d $CAM_DEVICE $REG_SET_FILE
# Use the "cam_regs.py" tool, only for special register settings, that are not available through v4l2_control.

echo "starting capture with v4l2-ctl command line with format Y10"
echo "read $X_RES x $Y_RES and write to file $CAMERA"_"Y10"".raw"
echo "================================================================"

v4l2-ctl --set-fmt-video=width=$X_RES,height=$Y_RES,pixelformat=$COL_FMT --stream-mmap --stream-count=2 --stream-skip 1 --stream-to=$CAMERA"_"Y10".raw"
