#!/bin/sh

GST_PATH="/usr/local/phytec-camera-examples/phytec-gstreamer-examples"
. $GST_PATH/func.sh

init_dev
[ $? -ne 0 ] && exit 1

guess_param

echo " pixel depth"
echo " ================="
echo " 1 = 8-Bit"
echo " 2 = 10-Bit"
read PIX_DEPTH
echo " Your select = $PIX_DEPTH"
case $PIX_DEPTH in
  "1") CAM_BW_FMT="Y8_1X8";;
  "2") CAM_BW_FMT="Y10_1X10";;
  *) CAM_BW_FMT="Y8_1x8";;
esac

echo ""
echo " configure camera with v4l2_control"
echo " ========================================"

$V4L2_CTRL_CAM0

# Additional Settings
BW_FMT=${CAM_BW_FMT%%_*}
X_RES=${SENSOR_RES%%x*}
Y_RES=${SENSOR_RES##*x}

echo ""
echo "starting save_raw_image with format $CAM_BW_FMT"
echo "read $X_RES x $Y_RES and write to RAW-file"
echo "============================================="

yavta "$CAM_DEVICE" -c8 --skip 7 -f "$BW_FMT" -s "${X_RES}x${Y_RES}" -F$CAMERA"_PixDepth_"$CAM_BW_FMT".raw"
#save_raw_image -D $CAM_DEVICE -no_subdev -f $BW_FMT -res_x $X_RES -res_y $Y_RES -d $NUMBER_OF_PIC -n $CAMERA"_PixDepth_"$CAM_BW_FMT"_"
