#!/bin/sh

init_dev() {

echo "====================================================================="

if [ -d /sys/bus/i2c/drivers/mt9v032/?-00* ]; then
	CAMERA="VM-010"
	CAM_DRIVER="mt9v032"
	CAM_I2C_ADRESS=$(find /sys/bus/i2c/drivers/mt9v032/ -name "?-00*" | cut -d / -f 7 | cut -c5-6)
	CAM_I2C_BUS=$(find /sys/bus/i2c/drivers/mt9v032/ -name "?-00*" | cut -d / -f 7 | cut -c1-1)
elif [ -d /sys/bus/i2c/drivers/ar0144/?-00* ]; then
	CAMERA="VM-016"
	CAM_DRIVER="ar0144"
	CAM_I2C_ADRESS=$(find /sys/bus/i2c/drivers/ar0144/ -name "?-00*" | cut -d / -f 7 | cut -c5-6)
	CAM_I2C_BUS=$(find /sys/bus/i2c/drivers/ar0144/ -name "?-00*" | cut -d / -f 7 | cut -c1-1)
else
	echo "no camera driver loaded"
	echo "please check camera device tree"
	echo ""
	return 1
fi

CAM_DEVICE="/dev/video0"
echo " camera = $CAMERA at i2c bus=$CAM_I2C_BUS with i2c adress=0x$CAM_I2C_ADRESS installed"
echo " camera driver = $CAM_DRIVER"
echo " camera device name = $CAM_DEVICE"
echo ""
return 0
}


guess_param() {
	FRAME_SIZE=",width=752,height=480"
	REG_SET_FILE="register-settings-mt9v02x.txt"
	COL_FORMAT="bayer,format=grbg"
	COL_FORMAT_XV="yuv"
#	COL_FORMAT_SCALE="yuv"
	BAYER_CONVERT="bayer2rgbneon ! "
	RAW_COL_FORMAT="bayer"
	NUMBER_OF_PIC="3"
	NORM=""
	if [ $CAMERA = "VM-010" ]; then
		FRAME_SIZE=",width=752,height=480"
		FRAME_SIZE_LIVE_DEMO=",width=752,height=480"
		SENSOR_RES="752x480"
		REG_SET_FILE="$(dirname $0)/register-settings-mt9v02x.txt"
		COL_FORMAT="bayer,format=grbg" && BAYER_CONVERT="bayer2rgbneon ! "
		RAW_COL_FORMAT="bayer,format=grbg" && COL_FORMAT_XV=$COL_FORMAT
#		COL_FORMAT_SCALE="rgb"
		V4L2_CTRL_CAM0='v4l2-ctl -d '$CAM_DEVICE' -c row_noise_correction=1'
	elif [ $CAMERA = "VM-016" ]; then
		FRAME_SIZE=",width=1280,height=800"
		FRAME_SIZE_LIVE_DEMO=",width=1280,height=800"
		SENSOR_RES="1280x800"
		SENSOR_RES_LIVE_DEMO="1280x800"
		GRAB_RES="1280x800"
		OFFSET_SENSOR="0,4"
		REG_SET_FILE="$(dirname $0)/register-settings-ar0144.txt"
		CAM_BW_FMT="Y8"
		COL_FORMAT="bayer,format=grbg" && BAYER_CONVERT="bayer2rgbneon ! "
		CAM_COL_FMT="SGRBG8_1X8"
		RAW_COL_FORMAT="bayer,format=grbg" && COL_FORMAT_XV=$COL_FORMAT
		NUMBER_OF_PIC="5"
		V4L2_CTRL_CAM0='v4l2-ctl -d '$CAM_DEVICE' -c auto_exposure_max=720'
	else
		echo "No Camera found"
	fi
}
