#!/bin/sh
. `dirname $0`/func.sh

init_dev
[ $? -ne 0 ] && exit 1

guess_param

echo "================================================================================="
echo "starting gstreamer with COLOR (BAYER, YUV or RGB depend of camera typ) Source ..."
echo "read $FRAME_SIZE, convert to jpg and write to file col_$CAMERA.jpg"
echo "================================================================================="

echo ""
echo " configure camera with v4l2_control"
echo " =================================="

$V4L2_CTRL_CAM0
# ./tools/cam_regs.py -s subdev0 -d $CAM_DEVICE $REG_SET_FILE
# Use the "cam_regs.py" tool, only for special register settings, that are not available through v4l2_control.

echo ""
echo "start gstreamer, break with ctl-C"
echo "================================="

gst-launch-1.0 \
	v4l2src num-buffers=$NUMBER_OF_PIC device=$CAM_DEVICE $NORM ! \
	video/x-$COL_FORMAT$FRAME_SIZE !$BAYER_CONVERT \
	videoconvert ! \
	jpegenc ! \
	multifilesink location=col_$CAMERA.jpg
