#!/bin/sh

source /usr/local/phytec-camera-examples/phytec-gstreamer-examples/tools/func.sh

detect_sensor_type "DCMIPP"
select_format
select_mode "HD"

setup-pipeline-dcmipp -f ${CAM_FMT} -s ${CAP_WIDTH}x${CAP_HEIGHT} \
		-c ${CAM_WIDTH}x${CAM_HEIGHT} -o ${CAM_OFFSET}

set_controls

echo "================================================================================="
echo "Starting gstreamer with ${CAM_FMT} Source on ${INTERFACE}"
echo "Configured Sensor Mode: ${CAM_MODENAME}"
echo "Capturing ${CAP_WIDTH}x${CAP_HEIGHT} with ${CAP_FMT} from ${CAP_DEVICE}"
echo "================================================================================="

SOURCE="v4l2src device=${CAP_DEVICE}"
SINK="waylandsink fullscreen=true sync=false"

echo "  gst-launch-1.0 ${SOURCE} ! \\"
echo "    ${GST_FMT} ! \\"
if [ -n "${GST_CONV}" ] ; then
	echo "    ${GST_CONV} ! \\"
fi
echo "    ${SINK}"
echo ""

PIPELINE="${SOURCE} ! ${GST_FMT}"
if [ -n "${GST_CONV}" ] ; then
	PIPELINE="${PIPELINE} ! ${GST_CONV}"
fi
PIPELINE="${PIPELINE} ! ${SINK}"

su -l "weston" -c "gst-launch-1.0 ${PIPELINE}"
