#!/bin/sh

source /usr/local/phytec-camera-examples/phytec-gstreamer-examples/tools/func.sh

detect_camera_interface
detect_sensor_type $INTERFACE
select_format_interactive
select_mode_interactive

setup-pipeline-dcmipp -f ${CAM_FMT} -s ${CAP_WIDTH}x${CAP_HEIGHT} \
	-c ${CAM_WIDTH}x${CAM_HEIGHT} -o ${CAM_OFFSET}

set_controls

MODE_NAME="$(echo ${CAM_MODENAME} | cut -d' ' -f-2 | sed 's# #_#g')"
FILE_NAME="${CAM_NAME}_${CAM_COLOR}_${YAVTA_FMT}_${MODE_NAME}.raw"

if [ -e ${FILE_NAME} ] ; then
	rm ${FILE_NAME}
fi

echo "================================================================================="
echo "Starting Yavta with ${CAM_FMT} Source on ${INTERFACE}"
echo "Configured Sensor Mode: ${CAM_MODENAME}"
echo "Capturing ${CAP_WIDTH}x${CAP_HEIGHT} with ${YAVTA_FMT} from ${CAP_DEVICE}"
echo "and saving the raw data as ${FILE_NAME}"
echo "================================================================================="

SIZE="${CAP_WIDTH}x${CAP_HEIGHT}"
COUNT="8"
SKIP="7"

echo "  yavta -c${COUNT} --skip ${SKIP} -s${SIZE} \\"
echo "        -f${YAVTA_FMT} -F${FILE_NAME} ${CAP_DEVICE}"
echo ""

yavta -c${COUNT} --skip ${SKIP} -s${SIZE} -f${YAVTA_FMT} -F${FILE_NAME} ${CAP_DEVICE}
