#!/bin/sh

source /usr/local/phytec-camera-examples/phytec-gstreamer-examples/tools/func.sh

detect_sensor_type "DCMIPP"
select_format
select_mode_interactive

setup-pipeline-dcmipp -f ${CAM_FMT} -s ${CAP_WIDTH}x${CAP_HEIGHT} \
	-c ${CAM_WIDTH}x${CAM_HEIGHT} -o ${CAM_OFFSET}

set_controls

MODE_NAME="$(echo ${CAM_MODENAME} | cut -d' ' -f-2 | sed 's# #_#g')"

echo "================================================================================="
echo "Starting gstreamer with ${CAM_FMT} Source on ${INTERFACE}"
echo "Configured Sensor Mode: ${CAM_MODENAME}"
echo "Capturing ${CAP_WIDTH}x${CAP_HEIGHT} with ${CAP_FMT} from ${CAP_DEVICE},"
echo "converting it to JPG and saving it as ${CAM_NAME}_${CAM_COLOR}_${MODE_NAME}.jpg"
echo "================================================================================="

SOURCE="v4l2src device=${CAP_DEVICE} num-buffers=${CAP_FRAME_CNT}"
ENCODING="jpegenc"
SINK="multifilesink location=${CAM_NAME}_${CAM_COLOR}_${MODE_NAME}.jpg"

echo "  gst-launch-1.0 ${SOURCE} ! \\"
echo "    ${GST_FMT} ! \\"
if [ -n "${GST_CONV}" ] ; then
	echo "    ${GST_CONV} ! \\"
fi
echo "    ${ENCODING} ! \\"
echo "    ${SINK}"
echo ""

PIPELINE="${SOURCE} ! ${GST_FMT}"
if [ -n "${GST_CONV}" ] ; then
	PIPELINE="${PIPELINE} ! ${GST_CONV}"
fi
PIPELINE="${PIPELINE} ! ${ENCODING} ! ${SINK}"

gst-launch-1.0 ${PIPELINE}
