#!/usr/bin/env python3

import os
import re
import subprocess
from argparse import ArgumentParser

def main():
    parser = ArgumentParser()
    parser.add_argument("reg", type=str, help="register-settings.txt file")
    parser.add_argument("-d", "--dev", type=str,
                        default="/dev/video0",
                        help="Video device e.g. /dev/video0",)
    parser.add_argument("-s", "--subdev", type=str,
                        default="subdev0",
                        help="Sub device e.g. subdev0")
    args = parser.parse_args()

    if not os.path.isfile(args.reg):
        raise AttributeError("Supplied file is not existing")

    with open(args.reg, "r") as f:
        data = f.readlines()
        for line in data:
            line = line.split("#")[0]
            if not line or line.isspace():
                continue
            line = line.strip().split(",")
            if len(line) == 3:
                value = line[2]
            elif len(line) == 4:
                call = ["v4l2-dbg", "-c", args.subdev, "-d", args.dev, "-g", line[1]]
                ret = subprocess.run(call, capture_output=True)
                value = re.search(b"= ([0-9a-fA-F]+)h", ret.stdout).group(1)
                value = int(value, 16)
                if line[3] == "a":
                    value = hex(int(line[2], 0) & value)
                elif line[3] == "o":
                    value = hex(int(line[2], 0) | value)
                else:
                    raise AttributeError("Wrong and/or operator: {}".format(line))

            else:
                raise AttributeError("Something is wrong with this line: {}".format(line))

            call = ["v4l2-dbg", "-c", args.subdev, "-d", args.dev, "-s", line[1], value]
            subprocess.run(call)

if __name__ == "__main__":
    main()
