#!/bin/sh
. `dirname $0`/../func.sh

init_dev
[ $? -ne 0 ] && exit 1

guess_param

echo "==============================================================="
echo "starting gstreamer with GRAY Source ..."
echo "read 1280x800, and write to framebuffer 1280x800"
echo "==============================================================="

echo ""
echo " configure camera with v4l2_control"
echo " =================================="

$V4L2_CTRL_CAM0
# ./../tools/cam_regs.py -s subdev0 ./../$REG_SET_FILE
# Use the "cam_regs.py" tool, only for special register settings, that are not available through v4l2_control.

echo ""
echo "start gstreamer, break with ctl-C"
echo "================================="

su -l "weston" -c "gst-launch-1.0 \
	v4l2src device=$CAM_DEVICE ! \
	video/x-raw,format=GRAY8,depth=8,width=1280,height=800 ! \
	videoconvert ! \
	waylandsink fullscreen=true sync=false"
