#!/bin/sh
. `dirname $0`/../func.sh

init_dev
[ $? -ne 0 ] && exit 1

guess_param

echo "==============================================================="
echo "starting gstreamer with Bayer Source ..."
echo "read 640x400, and write to framebuffer 640x400"
echo "==============================================================="

echo ""
echo " configure camera with v4l2_control"
echo " =================================="

$V4L2_CTRL_CAM0
# ./../tools/cam_regs.py -s subdev0 ./../$REG_SET_FILE
# Use the "cam_regs.py" tool, only for special register settings, that are not available through v4l2_control.

echo ""
echo "start gstreamer, break with ctl-C"
echo "================================="

su -l "weston" -c "gst-launch-1.0 \
	v4l2src device=$CAM_DEVICE ! \
	video/x-bayer,format=grbg,depth=8,width=640,height=400 ! \
	bayer2rgbneon ! \
	waylandsink fullscreen=true sync=false"
