#!/bin/sh
. `dirname $0`/func.sh

init_dev
[ $? -ne 0 ] && exit 1

guess_param

echo "================================================================================="
echo "starting gstreamer with Monochrome Source ..."
echo "read $FRAME_SIZE_LIVE_DEMO, convert and write to framebuffer"
echo "================================================================================="

echo ""
echo " configure camera with v4l2_control"
echo " =================================="

$V4L2_CTRL_CAM0
# ./tools/cam_regs.py -s subdev0 -d $CAM_DEVICE $REG_SET_FILE
# Use the "cam_regs.py" tool, only for special register settings, that are not available through v4l2_control.

echo ""
echo "start gstreamer, break with ctl-C"
echo "================================="

su -l "weston" -c "gst-launch-1.0 \
	v4l2src device=$CAM_DEVICE $NORM ! \
	video/x-raw,format=GRAY8,depth=8$FRAME_SIZE_LIVE_DEMO ! \
	videoconvert ! video/x-raw$FRAME_SIZE_LIVE_DEMO ! \
	videoscale ! video/x-raw,width=640,height=480 ! \
	waylandsink fullscreen=true sync=false"
