#!/bin/sh

GST_PATH="/usr/local/phytec-camera-examples/phytec-gstreamer-examples"
. $GST_PATH/func.sh

init_dev
[ $? -ne 0 ] && exit 1

guess_param

# Additional Settings
COL_FMT="SGRBG8"
X_RES=${SENSOR_RES%%x*}
Y_RES=${SENSOR_RES##*x}
REG_SET_FILE=$GST_PATH/${REG_SET_FILE##*/}

echo ""
echo " configure camera with v4l2_control"
echo " =================================="

$V4L2_CTRL_CAM0
#$GST_PATH/tools/cam_regs.py -s subdev0 -d $CAM_DEVICE $REG_SET_FILE
# Use the "cam_regs.py" tool, only for special register settings, that are not available through v4l2_control.

echo "starting save_raw_image with format $COL_FMT"
echo "read $X_RES x $Y_RES and write to file $CAMERA"_"$COL_FMT"_"x.raw"
echo "================================================================"

yavta "$CAM_DEVICE" -c2 --skip 1 -f "$COL_FMT" -s "${X_RES}x${Y_RES}" -F$CAMERA"_"$COL_FMT".raw"
