#!/bin/sh
. `dirname $0`/../../func.sh

init_dev
[ $? -ne 0 ] && exit 1

guess_param



echo "starting gstreamer iin $CAM_COL_FORMAT Source ..."
echo "read $SENSOR_RES (offset x,y=$OFFSET_SENSOR) and write to file mt9v024_bayer_10bit.raw"
echo "======================================================================================"
echo ""
echo "configure IPU/VPU with media_control"
echo "===================================="

media-ctl -r
media-ctl -V ''$CAM_ENTITY_NUMBER'0[fmt:'SGRBG10'/'$SENSOR_RES'('$OFFSET_SENSOR')/'$SENSOR_RES']'
media-ctl -V '"ipu0-csi0-sd":0[fmt:'SGRBG10'/'$SENSOR_RES']'
media-ctl -V '"ipu0-csi0-sd":1[fmt:'SGRBG10'/'$SENSOR_RES']'
#media-ctl -l '2:0 -> 1:0[1], 1:1 -> 2:0[1]'
#           Camera -> IPU0-CSI0-sd -> IPU0-CSI0-video (/dev/videoX)

echo ""
echo "start gstreamer"
echo "==============="

gst-launch-1.0 \
	v4l2src num-buffers=$NUMBER_OF_PIC device=$IPU0_CSI0_DEVICE ! \
	i2c file=`dirname $0`/../../register-settings-mt9v02x.txt show=0 dev=$CAM_DEVICE ! \
	video/x-bayer,format=grbg,depth=10,width=752,height=480 ! \
	multifilesink location=mt9v024_bayer_10bit.raw

