#!/bin/sh
. `dirname $0`/../func.sh

init_dev
[ $? -ne 0 ] && exit 1

guess_param

echo 0 > /sys/class/graphics/fbcon/cursor_blink


echo "starting gstreamer with Bayer Source ..."
echo "read 752x480 (offset x,y=1,5) and write to framebuffer 752x480"
echo "=============================================================================="
echo ""
echo "configure IPU/VPU with media_control"
echo "===================================="

media-ctl -r
media-ctl -V ''$CAM_ENTITY_NUMBER'0[fmt:SGRBG8/752x480 (1,5)/752x480]'
media-ctl -V '"ipu0-csi0-sd":0[fmt:SGRBG8/752x480]'
media-ctl -V '"ipu0-csi0-sd":1[fmt:SGRBG8/752x480]'
#media-ctl -l '2:0 -> 1:0[1], 1:1 -> 2:0[1]'
#           Camera -> IPU0-CSI0-sd -> IPU0-CSI0-video (/dev/videoX)   

echo ""
echo "start gstreamer, break with ctl-C"
echo "================================="

gst-launch-1.0 \
	v4l2src device=$IPU0_CSI0_DEVICE ! \
	i2c file=`dirname $0`/../register-settings-mt9v02x.txt show=0 dev=$CAM_DEVICE ! \
	video/x-bayer,format=grbg,depth=8,width=752,height=480 ! \
	bayer2rgb ! \
	videoconvert ! \
	fbdevsink sync=false

echo 1 > /sys/class/graphics/fbcon/cursor_blink