#!/bin/sh
. `dirname $0`/../../func.sh



# check the devices with "media-ctl -p"
IPU0_CSI0_DEVICE_0="/dev/video0"
CAM_DEVICE_0="/dev/v4l-subdev3"
IPU0_CSI0_DEVICE_1="/dev/video5"
CAM_DEVICE_1="/dev/v4l-subdev7"

echo "starting gstreamer with two GRAY Sources ..."
echo "read camera_0 from CSI0 and camera_1 from CSI1 with 752 x 480"
echo "and write it side by side into two files 720x480 mt9v024_gray_csix_image.raw"
echo "============================================================================"
echo ""
echo "configure IPU/VPU with media_control"
echo "===================================="

media-ctl -r
media-ctl -V '"mt9v032 2-0048":0[fmt:Y8/752x480 (1,5)/752x480]'
media-ctl -V '"ipu0-csi0-sd":0[fmt:Y8/752x480]'
media-ctl -V '"ipu0-csi0-sd":1[fmt:Y8/752x480]'
#media-ctl -l '2:0 -> 1:0[1], 1:1 -> 2:0[1]'
#           Camera -> IPU0-CSI0-sd -> IPU0-CSI0-video (/dev/videoX)   

media-ctl -V '"mt9v032 2-004c":0[fmt:Y8/752x480 (1,5)/752x480]'
media-ctl -V '"ipu1-csi1-sd":0[fmt:Y8/752x480]'
media-ctl -V '"ipu1-csi1-sd":1[fmt:Y8/752x480]'
#media-ctl -l '9:0 -> 8:0[1], 8:1 -> 10:0[1]'
#           Camera -> IPU0-CSI0-sd -> IPU0-CSI0-video (/dev/videoX)   

gst-launch-1.0 \
	v4l2src num-buffers=3 device=$IPU0_CSI0_DEVICE_0 ! \
	i2c addr=0x48 file=`dirname $0`/../../register-settings-mt9v02x.txt show=0 dev=$CAM_DEVICE_0 ! \
	video/x-raw,format=GRAY8,depth=8,width=752,height=480 ! \
	multifilesink location=mt9v024_gray_csi0_image.raw
	
gst-launch-1.0 \
	v4l2src num-buffers=3 device=$IPU0_CSI0_DEVICE_1 ! \
	i2c addr=0x4c file=`dirname $0`/../../register-settings-mt9v02x.txt show=0 dev=$CAM_DEVICE_1 ! \
	video/x-raw,format=GRAY8,depth=8,width=752,height=480 ! \
	multifilesink location=mt9v024_gray_csi1_image.raw

echo "File \"mt9v024_gray_csix_image.raw\" (format=gray[Y8], 1504x480 Pixel)"