#!/bin/sh
. `dirname $0`/../func.sh

init_dev
[ $? -ne 0 ] && exit 1

guess_param

echo 0 > /sys/class/graphics/fbcon/cursor_blink

echo "starting gstreamer with $CAM_BW_FMT Source ..."
echo "read $SENSOR_RES (offset x,y=$OFFSET_SENSOR), encode2jpeg and write to file mt9p031_image.jpg"
echo "==========================================================================================="
echo ""
echo "configure IPU/VPU with media_control"
echo "===================================="

media-ctl -r
media-ctl -V ''$CAM_ENTITY_NUMBER'0[fmt:'$CAM_BW_FMT'/'$SENSOR_RES'('$OFFSET_SENSOR')/'$SENSOR_RES']'
media-ctl -V '"ipu0-csi0-sd":0[fmt:Y8/'$SENSOR_RES']'
media-ctl -V '"ipu0-csi0-sd":1[fmt:Y8/'$SENSOR_RES']'
#media-ctl -l '10:0 -> 9:0[1], 9:1 -> 1:0[1], 1:1 -> 2:0[1]'
#            Camera -> ColShifter -> IPU0-CSI0 -> Out 

echo ""
echo "start gstreamer"
echo "==============="

gst-launch-1.0 \
	v4l2src num-buffers=$NUMBER_OF_PIC device=$IPU0_CSI0_DEVICE ! \
	i2c file=`dirname $0`/../register-settings-mt9p031.txt show=0 dev=$CAM_DEVICE ! \
	video/x-raw,format=GRAY8,depth=8$FRAME_SIZE ! \
	videoconvert ! \
	jpegenc ! \
	multifilesink location=mt9p031_image.jpg


echo 1 > /sys/class/graphics/fbcon/cursor_blink