#!/bin/sh
. `dirname $0`/../func.sh

init_dev
[ $? -ne 0 ] && exit 1

guess_param

echo 0 > /sys/class/graphics/fbcon/cursor_blink

echo "select resolution"
echo "================="
echo "1 = 2592 x 1944 Full"
echo "2 = 2048 x 1536 QXGA"
echo "3 = 1600 x 1200 UXGA"
echo "4 = 1280 x 1024 SXGA"
echo "5 = 1024 x 768  XGA"
echo "6 = 800  x 600  SVGA"
echo "7 = 640  x 480  VGA"
echo "8 = 1920 x 1080 FullHD"
echo "9 = 1280 x 720  HD"
read RESOLUTION
echo "Your select = $RESOLUTION"
case $RESOLUTION in
  "1") SENSOR_RES_LIVE_DEMO="2592x1944"; GRAB_RES="2592x1944"; FRAME_SIZE=",width=2592,height=1944"; OFFSET_SENSOR="16,54"; SCALE_SIZE=",width=640,height=480" ;;
  "2") SENSOR_RES_LIVE_DEMO="2048x1536"; GRAB_RES="2048x1536"; FRAME_SIZE=",width=2048,height=1536"; OFFSET_SENSOR="288,258"; SCALE_SIZE=",width=640,height=480" ;;
  "3") SENSOR_RES_LIVE_DEMO="1600x1200"; GRAB_RES="1600x1200"; FRAME_SIZE=",width=1600,height=1200"; OFFSET_SENSOR="512,426"; SCALE_SIZE=",width=640,height=480" ;;
  "4") SENSOR_RES_LIVE_DEMO="1280x1024"; GRAB_RES="1280x1024"; FRAME_SIZE=",width=1280,height=1024"; OFFSET_SENSOR="672,514"; SCALE_SIZE=",width=600,height=480" ;;
  "5") SENSOR_RES_LIVE_DEMO="2048x1536"; GRAB_RES="1024x768"; FRAME_SIZE=",width=1024,height=768"; OFFSET_SENSOR="288,258"; SCALE_SIZE=",width=640,height=480" ;;
  "6") SENSOR_RES_LIVE_DEMO="1600x1200"; GRAB_RES="800x600"; FRAME_SIZE=",width=800,height=600"; OFFSET_SENSOR="512,426"; SCALE_SIZE=",width=640,height=480" ;;
  "7") SENSOR_RES_LIVE_DEMO="2560x1920"; GRAB_RES="640x480"; FRAME_SIZE=",width=640,height=480"; OFFSET_SENSOR="32,66"; SCALE_SIZE=",width=640,height=480" ;;
  "8") SENSOR_RES_LIVE_DEMO="1920x1080"; GRAB_RES="1920x1080"; FRAME_SIZE=",width=1920,height=1080"; OFFSET_SENSOR="352,486"; SCALE_SIZE=",width=800,height=450" ;;
  "9") SENSOR_RES_LIVE_DEMO="2560x1440"; GRAB_RES="1280x720"; FRAME_SIZE=",width=1280,height=720"; OFFSET_SENSOR="32,306"; SCALE_SIZE=",width=800,height=450" ;;
  *) SENSOR_RES_LIVE_DEMO="2592x1944"; GRAB_RES="2592x1944"; FRAME_SIZE=",width=2592,height=1944"; OFFSET_SENSOR="16,54"; SCALE_SIZE=",width=640,height=480" ;;
esac

echo "starting gstreamer with $CAM_BW_FMT Source ..."
echo "read $FRAME_SIZE (offset x,y=$OFFSET_SENSOR) and write scaled to framebuffer $SCALE_SIZE"
echo "=============================================================="
echo ""
echo "configure IPU/VPU with media_control"
echo "===================================="

media-ctl -r
media-ctl -V ''$CAM_ENTITY_NUMBER'0[fmt:'$CAM_BW_FMT'/'$GRAB_RES'('$OFFSET_SENSOR')/'$SENSOR_RES_LIVE_DEMO']'
media-ctl -V '"ipu0-csi0-sd":0[fmt:Y8/'$GRAB_RES']'
media-ctl -V '"ipu0-csi0-sd":1[fmt:Y8/'$GRAB_RES']'
#media-ctl -l '2:0 -> 1:0[1], 1:1 -> 2:0[1]'
#           Camera -> IPU0-CSI0-sd -> IPU0-CSI0-video (/dev/videoX) 

echo ""
echo "start gstreamer, break with ctl-C"
echo "================================="

gst-launch-1.0 \
	v4l2src device=$IPU0_CSI0_DEVICE ! \
	i2c file=`dirname $0`/../register-settings-mt9p031.txt show=0 dev=$CAM_DEVICE ! \
	video/x-raw,format=GRAY8,depth=8$FRAME_SIZE,framerate=2/1 ! \
	videoscale ! \
	video/x-raw$SCALE_SIZE ! \
	videoconvert ! \
	fbdevsink sync=false
	
echo 1 > /sys/class/graphics/fbcon/cursor_blink