#!/bin/sh
. `dirname $0`/../../func.sh

init_dev
[ $? -ne 0 ] && exit 1

guess_param

echo 0 > /sys/class/graphics/fbcon/cursor_blink

echo "starting gstreamer with rgb Source ..."
echo "read 640x512 and write to framebuffer 640x480"
echo "only 640x512 activate PHYTEC-patch for skip 2"
echo "============================================="
echo ""
echo "configure IPU/VPU with media_control"
echo "===================================="

echo "set skip value via v4l2-ctl"
v4l2-ctl -d $CAM_DEVICE --set-ctrl=skip_x=1
v4l2-ctl -d $CAM_DEVICE --set-ctrl=skip_y=1

media-ctl -r
media-ctl -V ''$CAM_ENTITY_NUMBER'0[fmt:'$CAM_COL_FMT'/640x512('$OFFSET_SENSOR')/1280x1024]'
media-ctl -V '"ipu0-csi0-sd":0[fmt:'$CAM_COL_FMT'/640x512]'
media-ctl -V '"ipu0-csi0-sd":1[fmt:'$CAM_COL_FMT'/640x512]'
#media-ctl -l '2:0 -> 1:0[1], 1:1 -> 2:0[1]'
#           Camera -> IPU0-CSI0-sd -> IPU0-CSI0-video (/dev/videoX)

echo ""
echo "start gstreamer"
echo "==============="

gst-launch-1.0 \
	v4l2src device=$IPU0_CSI0_DEVICE ! \
	i2c file=$(dirname $0)/set_skip2_shutter.txt show=0 dev=$CAM_DEVICE ! \
	video/x-raw,format=UYVY,width=640,height=512 ! \
	videoconvert ! \
	videocrop top=16 bottom=16 left=0 right=0 ! \
	fbdevsink sync=false

echo 1 > /sys/class/graphics/fbcon/cursor_blink