#!/bin/sh
. `dirname $0`/../func.sh

init_dev
[ $? -ne 0 ] && exit 1

guess_param

echo 0 > /sys/class/graphics/fbcon/cursor_blink

echo "starting gstreamer with yuv Source ..."
echo "read 640x480 (sensor roi in center) write to framebuffer 640x480"
echo "============================================================"

echo ""
echo "configure IPU/VPU with media_control"
echo "===================================="

media-ctl -r
media-ctl -V ''$CAM_ENTITY_NUMBER'0[fmt:YUYV2X8/640x480(346,248)/640x480]'
media-ctl -V '"ipu0-csi0-sd":0[fmt:YUYV2X8/640x480]'
media-ctl -V '"ipu0-csi0-sd":1[fmt:YUYV2X8/640x480]'
#media-ctl -l '2:0 -> 1:0[1], 1:1 -> 2:0[1]'
#           Camera -> IPU0-CSI0-sd -> IPU0-CSI0-video (/dev/videoX)

echo ""
echo "start gstreamer, break with ctl-C"
echo "================================="

gst-launch-1.0 \
	v4l2src device=$IPU0_CSI0_DEVICE ! \
	i2c file=`dirname $0`/../register-settings-mt9m131.txt show=0 dev=$CAM_DEVICE ! \
	video/x-raw,format=UYVY,width=640,height=480 ! \
	videoconvert ! video/x-raw,width=640,height=480 ! \
	videoscale ! \
	video/x-raw,width=640,height=480 ! \
	fbdevsink sync=false
	
echo 1 > /sys/class/graphics/fbcon/cursor_blink
