#!/bin/sh
. `dirname $0`/../func.sh

init_dev
[ $? -ne 0 ] && exit 1

guess_param



echo "starting gstreamer with yuv Source ..."
echo "read 1280x1024 encode2jpeg and write to file mt9m131_yuv.jpg"
echo "============================================================"

echo ""
echo "configure IPU/VPU with media_control"
echo "===================================="

media-ctl -r
media-ctl -V ''$CAM_ENTITY_NUMBER'0[fmt:YUYV2X8/1280x1024(26,8)/1280x1024]'
media-ctl -V '"ipu0-csi0-sd":0[fmt:YUYV2X8/1280x1024]'
media-ctl -V '"ipu0-csi0-sd":1[fmt:YUYV2X8/1280x1024]'
#media-ctl -l '2:0 -> 1:0[1], 1:1 -> 2:0[1]'
#           Camera -> IPU0-CSI0-sd -> IPU0-CSI0-video (/dev/videoX)

echo ""
echo "start gstreamer, break with ctl-C"
echo "================================="

gst-launch-1.0 \
	v4l2src num-buffers=$NUMBER_OF_PIC device=$IPU0_CSI0_DEVICE ! \
	i2c file=`dirname $0`/../register-settings-mt9m131.txt show=0 dev=$CAM_DEVICE ! \
	video/x-raw,format=UYVY,width=1280,height=1024 ! \
	jpegenc ! \
	multifilesink location=mt9m131_yuv.jpg
	

