#!/bin/sh

init_dev() {

echo "====================================================================="

if [ -d /sys/bus/i2c/drivers/mt9v032/?-00* ]; then
	CAMERA="VM-010(mt9v024)"
	CAM_DRIVER="mt9v032"
	CAM_I2C_ADRESS=$(find /sys/bus/i2c/drivers/mt9v032/ -name "?-00*" | cut -d / -f 7 | cut -c5-6)
	CAM_I2C_BUS=$(find /sys/bus/i2c/drivers/mt9v032/ -name "?-00*" | cut -d / -f 7 | cut -c1-1)
elif [ -d /sys/bus/i2c/drivers/mt9p031/?-00* ]; then
	CAMERA="VM-011(mt9p031_mt9p006)"
	CAM_DRIVER="mt9p031"
	CAM_I2C_ADRESS=$(find /sys/bus/i2c/drivers/mt9p031/ -name "?-00*" | cut -d / -f 7 | cut -c5-6)
	CAM_I2C_BUS=$(find /sys/bus/i2c/drivers/mt9p031/ -name "?-00*" | cut -d / -f 7 | cut -c1-1)
elif [ -d /sys/bus/i2c/drivers/mt9m001/?-00* ]; then
	CAMERA="VM-006(mt9m001)"
	CAM_DRIVER="mt9m001"
	CAM_I2C_ADRESS=$(find /sys/bus/i2c/drivers/mt9m001/ -name "?-00*" | cut -d / -f 7 | cut -c5-6)
	CAM_I2C_BUS=$(find /sys/bus/i2c/drivers/mt9m001/ -name "?-00*" | cut -d / -f 7 | cut -c1-1)
elif [ -d /sys/bus/i2c/drivers/mt9m111/?-00* ]; then
	CAMERA="VM-009(mt9m131)"
	CAM_DRIVER="mt9m111"
	CAM_I2C_ADRESS=$(find /sys/bus/i2c/drivers/mt9m111/ -name "?-00*" | cut -d / -f 7 | cut -c5-6)
	CAM_I2C_BUS=$(find /sys/bus/i2c/drivers/mt9m111/ -name "?-00*" | cut -d / -f 7 | cut -c1-1)
elif [ -d /sys/bus/i2c/drivers/tw9910/?-00* ]; then
	CAMERA="VM-008(tw9910)"
	CAM_DRIVER="tw9910"
	CAM_I2C_ADRESS=$(find /sys/bus/i2c/drivers/tw9910/ -name "?-00*" | cut -d / -f 7 | cut -c5-6)
	CAM_I2C_BUS=$(find /sys/bus/i2c/drivers/tw9910/ -name "?-00*" | cut -d / -f 7 | cut -c1-1)
#elif [ -d /sys/bus/i2c/drivers/vita1300/?-00* ]; then
#	CAMERA="VM-012(vita1300)"
#	CAM_DRIVER="vita1300"
#	CAM_I2C_ADRESS=$(find /sys/bus/i2c/drivers/vita1300/ -name "?-00*" | cut -d / -f 7 | cut -c5-6)
#	CAM_I2C_BUS=$(find /sys/bus/i2c/drivers/vita1300/ -name "?-00*" | cut -d / -f 7 | cut -c1-1)
else
	echo "no camera driver loaded"
	echo "please check camera device tree" 
	echo ""
	return 1
fi

echo "camera = $CAMERA at i2c bus=$CAM_I2C_BUS with i2c adress=0x$CAM_I2C_ADRESS installed"
CAM_ENTITY_NUMBER=`media-ctl -p | grep " $CAM_DRIVER" | awk '{print $3}'`
CAM_DEVICE=$(media-ctl -e "$CAM_DRIVER $CAM_I2C_BUS-00$CAM_I2C_ADRESS")
IPU0_CSI0_DEVICE=$(media-ctl -e "ipu0-csi0-video")
IPU1_CSI1_DEVICE=$(media-ctl -e "ipu1-csi1-video")

if [ "$CAM_ENTITY_NUMBER" = "" ]; then
	echo "camera not found"
	echo "please check connected camera type, i2c adress and cable connections"
	echo ""
	return 1
fi
echo "camera entity name = $CAM_ENTITY_NUMBER"
echo "camera subdevice name = $CAM_DEVICE"
echo "ipu0_CSI0 devive name = $IPU0_CSI0_DEVICE"
echo "ipu1_CSI1 devive name = $IPU1_CSI1_DEVICE"
echo "camera driver = $CAM_DRIVER"
echo ""
return 0
}

guess_param() {
	COL_FORMAT="bayer,format=grbg,depth=8"
	BAYER_CONVERT=" bayer2rgb !"
	NUMBER_OF_PIC="3"
	NORM=""
#	COL_FORMAT_XV="yuv"
#	COL_FORMAT_SCALE="yuv"
#	RAW_COL_FORMAT="rgb"
	if [ $CAMERA = "VM-010(mt9v024)" ]; then
		FRAME_SIZE=",width=752,height=480"
		FRAME_SIZE_LIVE_DEMO=",width=752,height=480"
		REG_SET_FILE="$(dirname $0)/register-settings-mt9v02x.txt"
		SENSOR_RES="752x480"
		SENSOR_RES_LIVE_DEMO="752x480"
		GRAB_RES="752x480"
		OFFSET_SENSOR="1,5"
		CAM_BW_FMT="Y8"
		CAM_COL_FMT="SGRBG8"
		COL_FORMAT="bayer,format=grbg,depth=8"
		BAYER_CONVERT=" bayer2rgb !"
	elif [ $CAMERA = "VM-011(mt9p031_mt9p006)" ]; then
		FRAME_SIZE=",width=2592,height=1944"
		FRAME_SIZE_LIVE_DEMO=",width=640,height=480"
		REG_SET_FILE="$(dirname $0)/register-settings-mt9p031.txt"
		SENSOR_RES="2592x1944"
		SENSOR_RES_LIVE_DEMO="2560x1920"
		GRAB_RES="640x480"
		OFFSET_SENSOR="16,54"
		CAM_BW_FMT="Y8"
		CAM_COL_FMT="SGRBG8"
		COL_FORMAT="bayer,format=grbg,depth=8"
		BAYER_CONVERT=" bayer2rgb !"		
	elif [ $CAMERA = "VM-006(mt9m001)" ]; then
		FRAME_SIZE=",width=1280,height=1024"
		FRAME_SIZE_LIVE_DEMO=",width=1280,height=1024"
		REG_SET_FILE="$(dirname $0)/register-settings-mt9m001.txt"
		SENSOR_RES="1280x1024"
		SENSOR_RES_LIVE_DEMO="1280x1024"
		GRAB_RES="1280x1024"
		OFFSET_SENSOR="20,12"
		CAM_BW_FMT="Y8"
	elif [ $CAMERA = "VM-009(mt9m131)" ]; then
		FRAME_SIZE=",width=1280,height=1024"
		FRAME_SIZE_LIVE_DEMO=",width=1280,height=1024"
		REG_SET_FILE="$(dirname $0)/register-settings-mt9m131.txt"
		SENSOR_RES="1280x1024"
		SENSOR_RES_LIVE_DEMO="1280x1024"		
		GRAB_RES="1280x1024"
		OFFSET_SENSOR="26,8"		
		CAM_COL_FMT="YUYV2X8"
		COL_FORMAT="raw,format=UYVY"
		BAYER_CONVERT=""
		RAW_COL_FORMAT="rgb"
		COL_FORMAT_XV="yuv"
		COL_FORMAT_SCALE="yuv"
	elif [ $CAMERA = "VM-008(tw9910)" ]; then
		FRAME_SIZE=",width=720,height=576"
		FRAME_SIZE_LIVE_DEMO=",width=720,height=576"
		REG_SET_FILE="$(dirname $0)/register-settings-tw9910.txt"
		SENSOR_RES="720x576"
		SENSOR_RES_LIVE_DEMO="720x576"		
		GRAB_RES="720x576"
		OFFSET_SENSOR="0,0"		
		CAM_COL_FMT="UYVY2X8"
		COL_FORMAT="raw,format=UYVY"
		BAYER_CONVERT=""
		RAW_COL_FORMAT="rgb"
		COL_FORMAT_XV="yuv"
		COL_FORMAT_SCALE="yuv"
		NUMBER_OF_PIC="4"
		NORM="norm=PAL"
	else
		echo "No Camera found"
	fi
}
