#!/bin/sh
. `dirname $0`/func.sh

init_dev
[ $? -ne 0 ] && exit 1

guess_param

echo 0 > /sys/class/graphics/fbcon/cursor_blink


echo "starting gstreamer with GRAY Source ..."
echo "read $SENSOR_RES (offset x,y=$OFFSET_SENSOR), write to file bw_$CAMERA.raw"
echo "========================================================================"
echo ""
echo "configure IPU/VPU with media_control"
echo "===================================="

media-ctl -r
media-ctl -V ''$CAM_ENTITY_NUMBER'0[fmt:'$CAM_BW_FMT'/'$SENSOR_RES'('$OFFSET_SENSOR')/'$SENSOR_RES']'
media-ctl -V '"ipu0-csi0-sd":0[fmt:Y8/'$SENSOR_RES']'
media-ctl -V '"ipu0-csi0-sd":1[fmt:Y8/'$SENSOR_RES']'
#media-ctl -l '2:0 -> 1:0[1], 1:1 -> 2:0[1]'
#           Camera -> IPU0-CSI0-sd -> IPU0-CSI0-video (/dev/videoX)

echo ""
echo "start gstreamer"
echo "==============="

gst-launch-1.0 \
	v4l2src num-buffers=$NUMBER_OF_PIC device=$IPU0_CSI0_DEVICE ! \
	i2c file=$REG_SET_FILE show=0 dev=$CAM_DEVICE ! \
	video/x-raw,format=GRAY8,depth=8$FRAME_SIZE ! \
	multifilesink location=bw_$CAMERA.raw
	
echo "File \"bw_$CAMERA.raw\" (Y8$FRAME_SIZE)"

echo 1 > /sys/class/graphics/fbcon/cursor_blink