#!/bin/sh
. `dirname $0`/../func.sh

init_dev
[ $? -ne 0 ] && exit 1

guess_param

echo 0 > /sys/class/graphics/fbcon/cursor_blink


echo "==============================================================="
echo "starting gstreamer with Bayer Source ..."
echo "read 752x480 (offset x,y=1,5), and write to framebuffer 752x480"
echo "==============================================================="


echo ""
echo "start gstreamer, break with ctl-C"
echo "================================="

gst-launch-1.0 \
	v4l2src device=$DEVICE ! \
	i2c file=`dirname $0`/../register-settings-mt9v02x.txt show=0 dev=$DEVICE ! \
	video/x-bayer,format=bggr,depth=8,width=752,height=480 ! \
	bayer2rgbneon ! \
	imxpxpvideosink use-vsync=true sync=false

echo 1 > /sys/class/graphics/fbcon/cursor_blink