#!/bin/sh

init_dev() {

echo "====================================================================="

if [ -d /sys/bus/i2c/drivers/mt9v022/?-00* ]; then
	CAMERA="VM-010(mt9v02x)"
	CAM_I2C_ADRESS=$(find /sys/bus/i2c/drivers/mt9v022/ -name "?-00*" | cut -d / -f 7 | cut -c5-6)
	echo "$CAMERA at i2c adress 0x$CAM_I2C_ADRESS detect"
else
	if [ -d /sys/bus/i2c/drivers/mt9m001/?-00* ]; then
		CAMERA="VM-006(mt9m001)"
		CAM_I2C_ADRESS=$(find /sys/bus/i2c/drivers/mt9m001/ -name "?-00*" | cut -d / -f 7 | cut -c5-6)
		echo "$CAMERA at i2c adress 0x$CAM_I2C_ADRESS detect"
	else
		if [ -d /sys/bus/i2c/drivers/mt9m111/?-00* ]; then
			CAMERA="VM-050_051(vm050_phycam)"
			CAM_I2C_ADRESS=$(find /sys/bus/i2c/drivers/vm050_phycam/ -name "?-00*" | cut -d / -f 7 | cut -c5-6)
			echo "$CAMERA at i2c adress 0x$CAM_I2C_ADRESS detect"
		else
			if [ -d /sys/bus/i2c/drivers/mt9p031/?-00* ]; then
				CAMERA="VM-011(mt9p031/mt9p006)"
				CAM_I2C_ADRESS=$(find /sys/bus/i2c/drivers/mt9p031/ -name "?-00*" | cut -d / -f 7 | cut -c5-6)
				echo "$CAMERA at i2c adress 0x$CAM_I2C_ADRESS detect"
			else
				echo "no camera found"
				echo "please check cable connections" 
				echo ""
				return 1
			fi
		fi
	fi
fi
echo ""
return 0
}


guess_param() {
	DEVICE="/dev/video0"
	FRAME_SIZE=",width=752,height=480"
	REG_SET_FILE="register-settings-mt9v02x.txt"
	COL_FORMAT="bayer,format=bggr"
	COL_FORMAT_XV="yuv"
	COL_FORMAT_SCALE="yuv"
	BAYER_CONVERT="bayer2rgbneon ! "
	RAW_COL_FORMAT="bayer"
	NUMBER_OF_PIC="3"
	NORM=""
	[ $CAMERA = "VM-010(mt9v02x)" ] && FRAME_SIZE=",width=752,height=480" && \
		FRAME_SIZE_LIVE_DEMO=",width=752,height=480" && \
		REG_SET_FILE="$(dirname $0)/register-settings-mt9v02x.txt" && \
		COL_FORMAT="bayer,format=bggr" && BAYER_CONVERT="bayer2rgbneon ! " && \
		RAW_COL_FORMAT="bayer,format=bggr" && COL_FORMAT_XV=$COL_FORMAT && \
		COL_FORMAT_SCALE="rgb"
	[ $CAMERA = "VM-006(mt9m001)" ] && FRAME_SIZE=",width=1280,height=1024" && \
		FRAME_SIZE_LIVE_DEMO=",width=1280,height=1024" && \
		REG_SET_FILE="$(dirname $0)/register-settings-mt9m001.txt"
	[ $CAMERA = "VM-050_051(vm050_phycam)" ] && FRAME_SIZE=",width=32,height=32" && \
		FRAME_SIZE_LIVE_DEMO=",width=32,height=32" && \
		REG_SET_FILE="$(dirname $0)/register-settings-vm050_51.txt" && \
	[ $CAMERA = "VM-011(mt9p031/mt9p006)" ] && FRAME_SIZE=",width=2592,height=1944" && \
		FRAME_SIZE_LIVE_DEMO=",width=640,height=480" && \
		REG_SET_FILE="$(dirname $0)/register-settings-mt9p031.txt" && \
		COL_FORMAT="bayer,format=grbg" && BAYER_CONVERT="bayer2rgbneon ! " && \
		RAW_COL_FORMAT="bayer,format=grbg" && COL_FORMAT_XV=$COL_FORMAT && \
		COL_FORMAT_SCALE="rgb"
}
