#!/bin/sh
. `dirname $0`/func.sh

init_dev
[ $? -ne 0 ] && exit 1

guess_param



echo "================================================================================="
echo "starting gstreamer with COLOR (BAYER, YUV or RGB depend of camera typ) Source ..."
echo "read $FRAME_SIZE, write to file col_$CAMERA.raw"
echo "================================================================================="


echo ""
echo "start gstreamer, break with ctl-C"
echo "================================="

gst-launch-1.0 \
	v4l2src num-buffers=$NUMBER_OF_PIC device=$DEVICE ! \
	i2c file=$REG_SET_FILE show=0 dev=$DEVICE ! \
	video/x-$COL_FORMAT$FRAME_SIZE ! \
	multifilesink location=col_$CAMERA.raw

echo "File \"col_$CAMERA.raw\" ($COL_FORMAT$FRAME_SIZE)"