#!/bin/sh
. `dirname $0`/func.sh

init_dev
[ $? -ne 0 ] && exit 1

guess_param




echo "================================================================================="
echo "starting gstreamer with GRAY Source ..."
echo "read $FRAME_SIZE, convert to jpg and write to file bw_$CAMERA.jpg"
echo "================================================================================="


echo ""
echo "start gstreamer, break with ctl-C"
echo "================================="

gst-launch-1.0 \
	v4l2src num-buffers=$NUMBER_OF_PIC device=$DEVICE ! \
	i2c file=$REG_SET_FILE show=0 dev=$DEVICE ! \
	video/x-raw,format=GRAY8,depth=8$FRAME_SIZE ! \
	videoconvert ! \
	jpegenc ! \
	multifilesink location=bw_$CAMERA.jpg