#!/bin/sh
. `dirname $0`/func.sh

init_dev
[ $? -ne 0 ] && exit 1

guess_param

echo 0 > /sys/class/graphics/fbcon/cursor_blink


echo "================================================================================="
echo "starting gstreamer with Monochrome Source ..."
echo "read $FRAME_SIZE_LIVE_DEMO, convert and write to framebuffer"
echo "================================================================================="


echo ""
echo "start gstreamer, break with ctl-C"
echo "================================="

gst-launch-1.0 \
	v4l2src device=$DEVICE ! \
	i2c file=$REG_SET_FILE show=0 dev=$DEVICE ! \
	video/x-raw,format=GRAY8,depth=8$FRAME_SIZE_LIVE_DEMO ! \
	videoconvert ! \
	imxpxpvideosink use-vsync=true sync=false window-width=800 window-height=480
	
echo 1 > /sys/class/graphics/fbcon/cursor_blink