#!/bin/sh

. /usr/share/phytec-gstreamer-examples/func.sh

init_dev
[ $? -ne 0 ] && exit 1

guess_param

echo "pixel depth"
echo "================="
echo "1 = 8-Bit"
echo "2 = 10-Bit (only for phyCAM-P)"
read PIX_DEPTH
echo "Your select = $PIX_DEPTH"
case $PIX_DEPTH in
  "1") CAM_COL_FMT="SGRBG8";;
  "2") CAM_COL_FMT="SGRBG10";;
  *) CAM_COL_FMT="SGRBG8";;
esac

echo ""
echo "configure IPU/VPU with media_control"
echo "===================================="

media-ctl -r
media-ctl -V ''$CAM_ENTITY_NUMBER'0[fmt:'$CAM_COL_FMT'/'$SENSOR_RES'('$OFFSET_SENSOR')/'$SENSOR_RES']'
media-ctl -V '"ipu0-csi0-sd":0[fmt:'$CAM_COL_FMT'/'$SENSOR_RES']'
media-ctl -V '"ipu0-csi0-sd":1[fmt:'$CAM_COL_FMT'/'$SENSOR_RES']'
#media-ctl -l '2:0 -> 1:0[1], 1:1 -> 2:0[1]'
#           Camera -> IPU0-CSI0-sd -> IPU0-CSI0-video (/dev/videoX)

# Additional Settings
COL_FMT=$CAM_COL_FMT
X_RES=${SENSOR_RES%%x*}
Y_RES=${SENSOR_RES##*x}
REG_SET_FILE=/usr/share/phytec-gstreamer-examples/${REG_SET_FILE##*/}


echo "starting save_raw_image with format $COL_FMT"
echo "read $X_RES x $Y_RES and write to RAW-file"
echo "============================================="

save_raw_image -D $IPU0_CSI0_DEVICE -sd_cam $CAM_DEVICE -f $COL_FMT -res_x $X_RES -res_y $Y_RES -d $NUMBER_OF_PIC -r $REG_SET_FILE -n $CAMERA"_PixDepth_"$CAM_COL_FMT"_"
