//#include <sys/types.h>
//#include <sys/stat.h>
#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>        // für exit
#include <sys/ioctl.h>     // für ioctl
#include <linux/types.h>   // für __u32

#include <unistd.h>        // für close

#include <string.h>        // für strlen

/* !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
 * !!!                                                      !!!
 * !!! BIG FAT WARNING!                                     !!!
 * !!!                                                      !!!
 * !!! These are parts of kernel headers and are taken from !!!
 * !!! Linux-2.6.29. Do not expect this to run on any other !!!
 * !!! kernel than this one!                                !!!
 * !!!                                                      !!!
 * !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! */

struct v4l2_dbg_match {
  __u32 type;  // Match type
  union {      // Match this chip, meaning determined by type
    __u32 addr;
    char name [32];
  };
} __attribute__ ((packed));


struct v4l2_dbg_register {
  struct v4l2_dbg_match match;
  __u32 size;    // register size in bytes
  __u64 reg;
  __u64 val;
} __attribute__ ((packed));


#undef   VIDIOC_DBG_G_REGISTER
#define  VIDIOC_DBG_G_REGISTER   _IOWR ('V', 80, struct v4l2_dbg_register)
#undef   VIDIOC_DBG_S_REGISTER
#define  VIDIOC_DBG_S_REGISTER    _IOW ('V', 79, struct v4l2_dbg_register)

#define V4L2_CHIP_MATCH_I2C_ADDR   2   // Match against I2C 7-bit address


unsigned long int parse (char *s) {
  unsigned long int i;
  char *p;
  
  p = s;
  while (*p != 0) {
  	if ((*p == 'x') || (*p == 'X')) {
  	  sscanf (s, "%lx", &i);
  	  return i;
  	}
  	
  	p++;
  }

  sscanf (s, "%lu", &i);
  return i;
}

void print_help (char *argv) {
  printf("\nUsage:\n");
  printf("%s [-a addr] [-r reg] [-d device] [-v value] [-A | -O | -X]"
      "\n\n", argv);
}

int main (int argc, char *argv []) {
  int fd, ret, option, num_match = 0, set_value = 0;
  struct v4l2_dbg_register reg;
  unsigned long int value;
  char match, *dev = "/dev/video2";

  reg.match.addr = 0x5d; // i2c addr 5d: a mt9m001 sensor
  reg.reg = 0x20;

  while ((option = getopt(argc, argv, "ha:r:d:v:AOX")) != -1)
  {
    switch (option) {
      case 'h': print_help(argv[0]); 
                return 0;
      // Chipadresse bestimmen
      case 'a': sscanf (optarg, "%x", &reg.match.addr);
                break;
      // Zielregister bestimmen
      case 'r': sscanf (optarg, "%lx", &reg.reg);
                break;
      case 'v': value = parse(optarg);
                set_value = 1;
                break;
      case 'A': num_match++;
		match = 'A';
		break;
      case 'O': num_match++;
                match = 'O';
                break;
      case 'X': num_match++;
                match = 'X';
                break;
      case 'd': dev = optarg;
                break;
      case '?': print_help(argv[0]);
                return 1;
    }

    if (num_match > 1) {
      printf("Don't use A, O or X together.\n");
      return 1;
    }
  }

  printf("\n=== Values ===\n");
  printf("\t Device: %s\n", dev);
  printf("\t Address: %x\n", reg.match.addr);
  printf("\t Register: %lx\n", (__u32) reg.reg);

  // Open
  printf ("\n=== Open %s ===\n",dev);
  fflush (stdout);
  usleep (9000);   // Der Kernel wartet sonst trotz Flush nur für die Ausgabe bis vor den Zeilenvorschub
  
  fd = open (dev, O_RDWR);   // Meldungen des Kernels werden aber sofort rausgehauen!
  if (fd < 0) {
    perror ("ERROR open device");
    exit (1);
  }

  // Get Value
  printf ("\n=== Get ===\n");
  fflush (stdout);
  usleep (9000);   // Der Kernel wartet sonst trotz Flush nur für die Ausgabe bis vor den Zeilenvorschub

  reg.match.type = V4L2_CHIP_MATCH_I2C_ADDR;
  reg.val = 0x0;

  ret = ioctl (fd, VIDIOC_DBG_G_REGISTER, &reg);   // Meldungen des Kernels werden aber sofort rausgehauen!
  if (ret) {
    perror ("ERROR ioctl (get)");
    exit (1);
  }

  printf ("addr 0x%02x reg 0x%04x: 0x%04x (Size: %u Bytes)\n", reg.match.addr, (__u32) reg.reg, (__u32) reg.val, reg.size);
  fflush (stdout);
  usleep (9000);   // Der Kernel wartet sonst trotz Flush nur für die Ausgabe bis vor den Zeilenvorschub

  // Set Value nur bei Bedarf
  if (set_value) {
    switch (match & 0x5F) {
      case 'A': reg.val &= value; 
                printf ("\n=== And 0x%04d ===\n", value); 
                break;
      case 'O': reg.val |= value;
                printf ("\n=== Or 0x%04d ===\n", value);
                break;
      case 'X': reg.val ^= value;
                printf ("\n=== Xor 0x%04d ===\n", value);
                break;
      default:  reg.val = value;
                printf ("\n=== Set 0x%04d ===\n", value);
    }
    
    // Wert schreiben
    ret = ioctl (fd, VIDIOC_DBG_S_REGISTER, &reg);
    if (ret) {
      perror ("ERROR ioctl (set)");
      exit (1);
    }

    printf ("addr 0x%02x reg 0x%04x: 0x%04x\n", reg.match.addr, (__u32) reg.reg, (__u32) reg.val);
    fflush (stdout);
    usleep (9000);   // Der Kernel wartet sonst trotz Flush nur für die Ausgabe bis vor den Zeilenvorschub

    // Nun nochmal Get Value
    printf ("\n=== Get ===\n");
    fflush (stdout);
    usleep (9000);   // Der Kernel wartet sonst trotz Flush nur für die Ausgabe bis vor den Zeilenvorschub

    ret = ioctl (fd, VIDIOC_DBG_G_REGISTER, &reg);
    if (ret) {
      perror ("ERROR ioctl (get)");
      exit (1);
    }

    printf ("addr 0x%02x reg 0x%04x: 0x%04x\n", reg.match.addr, (__u32) reg.reg, (__u32) reg.val);
    fflush (stdout);
    usleep (9000);   // Der Kernel wartet sonst trotz Flush nur für die Ausgabe bis vor den Zeilenvorschub
  }
  
  // Close
  printf ("\n=== Close %s ===\n",dev);
  fflush (stdout);
  usleep (9000);   // Der Kernel wartet sonst trotz Flush nur für die Ausgabe bis vor den Zeilenvorschub
  
  close (fd);   // Meldungen des Kernels werden aber sofort rausgehauen!

  // Ende
  printf ("\n");
  return 0;
}
