#!/bin/sh
. `dirname $0`/func.sh

init_dev
[ $? -ne 0 ] && exit 1

guess_param

echo 0 > /sys/class/graphics/fbcon/cursor_blink


echo "starting gstreamer with COLOR (BAYER, YUV or RGB depend of camera typ) Source ..."
echo "read $SENSOR_RES (offset x,y=$OFFSET_SENSOR), write to file col_$CAMERA.raw"
echo "==========================================================================================="
echo ""
echo "configure IPU/VPU with media_control"
echo "===================================="

media-ctl -r
media-ctl -V ''$CAM_ENTITY_NUMBER'0[fmt:'$CAM_COL_FMT'/'$SENSOR_RES'('$OFFSET_SENSOR')/'$SENSOR_RES']'
media-ctl -V '"ipu0-csi0-sd":0[fmt:'$CAM_COL_FMT'/'$SENSOR_RES']'
media-ctl -V '"ipu0-csi0-sd":1[fmt:'$CAM_COL_FMT'/'$SENSOR_RES']'
#media-ctl -l '2:0 -> 1:0[1], 1:1 -> 2:0[1]'
#           Camera -> IPU0-CSI0-sd -> IPU0-CSI0-video (/dev/videoX)

echo ""
echo "start gstreamer"
echo "==============="

gst-launch-1.0 \
	v4l2src num-buffers=$NUMBER_OF_PIC device=$IPU0_CSI0_DEVICE $NORM ! \
	i2c file=$REG_SET_FILE show=0 dev=$CAM_DEVICE ! \
	video/x-$COL_FORMAT$FRAME_SIZE ! \
	multifilesink location=col_$CAMERA.raw

echo "File \"col_$CAMERA.raw\" ($COL_FORMAT$FRAME_SIZE)"

echo 1 > /sys/class/graphics/fbcon/cursor_blink