#!/bin/sh
. `dirname $0`/func.sh

init_dev
[ $? -ne 0 ] && exit 1

guess_param

echo 0 > /sys/class/graphics/fbcon/cursor_blink


echo "starting gstreamer with COLOR (BAYER, YUV or RGB depend of camera typ) Source ..."
echo "read $GRAB_RES (offset x,y=$OFFSET_SENSOR), convert and write to framebuffer 640x480"
echo "=============================================================================="
echo ""
echo "configure IPU/VPU with media_control"
echo "===================================="

media-ctl -r
media-ctl -V ''$CAM_ENTITY_NUMBER'0[fmt:'$CAM_COL_FMT'/'$GRAB_RES'('$OFFSET_SENSOR')/'$SENSOR_RES_LIVE_DEMO']'
media-ctl -V '"ipu0-csi0-sd":0[fmt:'$CAM_COL_FMT'/'$GRAB_RES']'
media-ctl -V '"ipu0-csi0-sd":1[fmt:'$CAM_COL_FMT'/'$GRAB_RES']'
#media-ctl -l '2:0 -> 1:0[1], 1:1 -> 2:0[1]'
#           Camera -> IPU0-CSI0-sd -> IPU0-CSI0-video (/dev/videoX)

echo ""
echo "start gstreamer, break with ctl-C"
echo "================================="

gst-launch-1.0 \
	v4l2src device=$IPU0_CSI0_DEVICE $NORM ! \
	i2c file=$REG_SET_FILE show=0 dev=$CAM_DEVICE ! \
	video/x-$COL_FORMAT$FRAME_SIZE_LIVE_DEMO !$BAYER_CONVERT \
	videoconvert ! video/x-raw$FRAME_SIZE_LIVE_DEMO ! \
	videoscale ! video/x-raw,width=640,height=480 ! \
	videoconvert ! \
	fbdevsink sync=false


echo 1 > /sys/class/graphics/fbcon/cursor_blink

